/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ehrbase.aql.binder.AqlBinder;
import org.ehrbase.aql.dto.AqlDto;
import org.ehrbase.aql.dto.condition.ConditionComparisonOperatorDto;
import org.ehrbase.aql.dto.condition.ConditionDto;
import org.ehrbase.aql.dto.condition.ConditionLogicalOperatorDto;
import org.ehrbase.aql.dto.condition.ParameterValue;
import org.ehrbase.aql.dto.condition.Value;
import org.ehrbase.aql.parser.AqlToDtoParser;
import org.ehrbase.client.aql.query.EntityQuery;

public class AqlUtil {
    private static final AqlToDtoParser PARSER = new AqlToDtoParser();
    private static final AqlBinder BINDER = new AqlBinder();

    private AqlUtil() {
    }

    public static String removeParameter(String aql, String parameterName) {
        AqlDto dto = PARSER.parse(aql);
        dto.setWhere(AqlUtil.removeParameter(dto.getWhere(), parameterName));
        return ((EntityQuery)BINDER.bind(dto).getLeft()).buildAql();
    }

    private static ConditionDto removeParameter(ConditionDto conditionDto, String parameterName) {
        if (conditionDto instanceof ConditionComparisonOperatorDto) {
            Value value = ((ConditionComparisonOperatorDto)conditionDto).getValue();
            if (value instanceof ParameterValue && Objects.equals(((ParameterValue)value).getName(), parameterName)) {
                return null;
            }
        } else if (conditionDto instanceof ConditionLogicalOperatorDto) {
            List<ConditionDto> values = ((ConditionLogicalOperatorDto)conditionDto).getValues();
            for (ConditionDto value : new ArrayList<ConditionDto>(values)) {
                values.remove(value);
                ConditionDto newValue = AqlUtil.removeParameter(value, parameterName);
                if (newValue == null) continue;
                values.add(newValue);
            }
            if (values.isEmpty()) {
                return null;
            }
            if (values.size() == 1) {
                return values.get(0);
            }
            return conditionDto;
        }
        return conditionDto;
    }
}

