/*
 * Decompiled with CFR 0.152.
 */
package com.github.edwgiz.mavenShadePlugin.log4j2CacheTransformer;

import com.github.edwgiz.mavenShadePlugin.log4j2CacheTransformer.CloseShieldOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.core.config.plugins.processor.PluginCache;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginsCacheFileTransformer
implements ResourceTransformer {
    private ArrayList<File> tempFiles = new ArrayList();

    public boolean canTransformResource(String resource) {
        return resource != null && "META-INF/org/apache/logging/log4j/core/config/plugins/Log4j2Plugins.dat".equals(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResource(String resource, InputStream is, List<Relocator> relocators) throws IOException {
        File tempFile = File.createTempFile("Log4j2Plugins", "dat");
        FileOutputStream fos = new FileOutputStream(tempFile);
        try {
            IOUtils.copyLarge((InputStream)is, (OutputStream)fos);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)fos);
        }
        this.tempFiles.add(tempFile);
    }

    public boolean hasTransformedResource() {
        return this.tempFiles.size() > 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        try {
            PluginCache aggregator = new PluginCache();
            aggregator.loadCacheFiles(this.getUrls());
            jos.putNextEntry(new JarEntry("META-INF/org/apache/logging/log4j/core/config/plugins/Log4j2Plugins.dat"));
            aggregator.writeCache((OutputStream)((Object)new CloseShieldOutputStream(jos)));
        }
        finally {
            for (File tempFile : this.tempFiles) {
                tempFile.delete();
            }
        }
    }

    private Enumeration<URL> getUrls() throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File tempFile : this.tempFiles) {
            URL url = tempFile.toURI().toURL();
            urls.add(url);
        }
        return Collections.enumeration(urls);
    }
}

