/*
 * Decompiled with CFR 0.152.
 */
package com.github.edsergeev;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.support.design.widget.FloatingActionButton;
import android.text.TextPaint;
import android.util.AttributeSet;
import com.github.edsergeev.R;

public class TextFloatingActionButton
extends FloatingActionButton {
    private static final int SANS = 1;
    private static final int SERIF = 2;
    private static final int MONOSPACE = 3;
    private final TextPaint mTextPaint;
    private final int yCenterOffset;
    private ColorStateList mTextColor;
    private CharSequence mText = "";
    private int textXoffset;
    private int textYoffset;

    public TextFloatingActionButton(Context context) {
        this(context, null);
    }

    public TextFloatingActionButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TextFloatingActionButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        Resources res = this.getResources();
        this.mTextPaint = new TextPaint(1);
        this.mTextPaint.density = res.getDisplayMetrics().density;
        this.mTextPaint.setTextAlign(Paint.Align.CENTER);
        this.yCenterOffset = -((int)((this.mTextPaint.descent() + this.mTextPaint.ascent()) / 2.0f));
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        CharSequence text = "";
        ColorStateList textColor = null;
        int textSize = 15;
        int typefaceIndex = -1;
        int styleIndex = -1;
        String fontFamily = null;
        boolean fontFamilyExplicit = false;
        Resources.Theme theme = context.getTheme();
        TypedArray a = theme.obtainStyledAttributes(attrs, R.styleable.TextFloatingActionButton, defStyleAttr, 0);
        int n = a.getIndexCount();
        for (int i = 0; i < n; ++i) {
            int attr = a.getIndex(i);
            if (attr == R.styleable.TextFloatingActionButton_android_text) {
                text = a.getText(attr);
                continue;
            }
            if (attr == R.styleable.TextFloatingActionButton_android_textColor) {
                textColor = a.getColorStateList(attr);
                continue;
            }
            if (attr == R.styleable.TextFloatingActionButton_android_textSize) {
                textSize = a.getDimensionPixelSize(attr, textSize);
                continue;
            }
            if (attr == R.styleable.TextFloatingActionButton_android_typeface) {
                typefaceIndex = a.getInt(attr, typefaceIndex);
                continue;
            }
            if (attr == R.styleable.TextFloatingActionButton_android_fontFamily) {
                fontFamily = a.getString(attr);
                fontFamilyExplicit = true;
                continue;
            }
            if (attr == R.styleable.TextFloatingActionButton_android_textStyle) {
                styleIndex = a.getInt(attr, styleIndex);
                continue;
            }
            if (attr == R.styleable.TextFloatingActionButton_text_x_offset) {
                this.textXoffset = a.getLayoutDimension(attr, 0);
                continue;
            }
            if (attr != R.styleable.TextFloatingActionButton_text_y_offset) continue;
            this.textYoffset = a.getLayoutDimension(attr, 0);
        }
        a.recycle();
        if (typefaceIndex != -1 && !fontFamilyExplicit) {
            fontFamily = null;
        }
        this.setTypefaceFromAttrs(fontFamily, typefaceIndex, styleIndex);
        this.setTextColor(textColor != null ? textColor : ColorStateList.valueOf((int)-16777216));
        this.mTextPaint.setTextSize((float)textSize);
        this.setText(text);
    }

    private void setTypefaceFromAttrs(String familyName, int typefaceIndex, int styleIndex) {
        Typeface tf = null;
        if (familyName != null && (tf = Typeface.create((String)familyName, (int)styleIndex)) != null) {
            this.setTypeface(tf);
            return;
        }
        switch (typefaceIndex) {
            case 1: {
                tf = Typeface.SANS_SERIF;
                break;
            }
            case 2: {
                tf = Typeface.SERIF;
                break;
            }
            case 3: {
                tf = Typeface.MONOSPACE;
            }
        }
        this.setTypeface(tf, styleIndex);
    }

    public void setTypeface(Typeface tf) {
        if (this.mTextPaint.getTypeface() != tf) {
            this.mTextPaint.setTypeface(tf);
            this.invalidate();
        }
    }

    public void setTypeface(Typeface tf, int style) {
        if (style > 0) {
            tf = tf == null ? Typeface.defaultFromStyle((int)style) : Typeface.create((Typeface)tf, (int)style);
            this.setTypeface(tf);
            int typefaceStyle = tf != null ? tf.getStyle() : 0;
            int need = style & ~typefaceStyle;
            this.mTextPaint.setFakeBoldText((need & 1) != 0);
            this.mTextPaint.setTextSkewX((need & 2) != 0 ? -0.25f : 0.0f);
        } else {
            this.mTextPaint.setFakeBoldText(false);
            this.mTextPaint.setTextSkewX(0.0f);
            this.setTypeface(tf);
        }
    }

    public void setTextColor(ColorStateList colors) {
        if (colors == null) {
            throw new NullPointerException();
        }
        this.mTextColor = colors;
    }

    public void setText(CharSequence text) {
        this.mText = text;
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int color = this.mTextColor.getColorForState(this.getDrawableState(), -16777216);
        this.mTextPaint.setColor(color);
        canvas.save();
        canvas.translate((float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
        canvas.drawText(this.mText, 0, this.mText.length(), (float)this.textXoffset, (float)(this.textYoffset + this.yCenterOffset), (Paint)this.mTextPaint);
        canvas.restore();
    }
}

