/*
 * Decompiled with CFR 0.152.
 */
package pl.exsio.querydsl.entityql.config;

import com.querydsl.sql.Configuration;
import com.querydsl.sql.SQLBaseListener;
import com.querydsl.sql.SQLCloseListener;
import com.querydsl.sql.SQLExceptionTranslator;
import com.querydsl.sql.SQLListener;
import com.querydsl.sql.SQLListenerContext;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.spring.SpringExceptionTranslator;
import com.querydsl.sql.types.AbstractType;
import com.querydsl.sql.types.BooleanType;
import com.querydsl.sql.types.EnumByNameType;
import com.querydsl.sql.types.EnumByOrdinalType;
import com.querydsl.sql.types.Type;
import com.querydsl.sql.types.UtilUUIDType;
import java.sql.Connection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class EntityQlQueryFactory
extends SQLQueryFactory {
    public EntityQlQueryFactory(Configuration configuration, DataSource dataSource) {
        super(configuration, () -> DataSourceUtils.getConnection((DataSource)dataSource));
        this.registerCustomTypes(configuration);
        this.closeConnectionIfNoTransaction(configuration, dataSource);
        configuration.setExceptionTranslator((SQLExceptionTranslator)new SpringExceptionTranslator());
    }

    public EntityQlQueryFactory registerEnumsByName(String enumPackage) {
        List<AbstractType<?>> enumTypes = this.getEnumTypes(enumPackage, EnumByNameType::new);
        enumTypes.forEach(arg_0 -> ((Configuration)this.configuration).register(arg_0));
        return this;
    }

    public EntityQlQueryFactory registerEnumsByOrdinal(String enumPackage) {
        List<AbstractType<?>> enumTypes = this.getEnumTypes(enumPackage, EnumByOrdinalType::new);
        enumTypes.forEach(arg_0 -> ((Configuration)this.configuration).register(arg_0));
        return this;
    }

    private void closeConnectionIfNoTransaction(Configuration configuration, final DataSource dataSource) {
        configuration.addListener((SQLListener)new SQLBaseListener(){

            public void end(SQLListenerContext context) {
                if (!DataSourceUtils.isConnectionTransactional((Connection)context.getConnection(), (DataSource)dataSource)) {
                    SQLCloseListener.DEFAULT.end(context);
                }
            }
        });
    }

    private void registerCustomTypes(Configuration configuration) {
        configuration.register((Type)new UtilUUIDType());
        configuration.register((Type)new BooleanType(2));
    }

    private List<AbstractType<?>> getEnumTypes(String enumPackage, Function<Class<? extends Enum>, AbstractType<?>> enumTypeCreator) {
        return new Reflections(enumPackage, new Scanner[0]).getSubTypesOf(Enum.class).stream().map(enumTypeCreator::apply).collect(Collectors.toList());
    }
}

