/*
 * Decompiled with CFR 0.152.
 */
package pl.exsio.querydsl.entityql;

import java.util.HashMap;
import java.util.Map;
import pl.exsio.querydsl.entityql.Q;
import pl.exsio.querydsl.entityql.entity.metadata.QEntityMetadata;
import pl.exsio.querydsl.entityql.entity.scanner.QEntityScanner;

class QFactory<E> {
    private final Class<E> entityClass;
    private final QEntityScanner scanner;
    private final QEntityMetadata metadata;
    private static final Map<Class<?>, QFactory<?>> instances = new HashMap();

    private QFactory(Class<E> entityClass, QEntityScanner scanner, QEntityMetadata metadata) {
        this.entityClass = entityClass;
        this.scanner = scanner;
        this.metadata = metadata;
    }

    static <E> QFactory<E> get(Class<E> entityClass, QEntityScanner scanner) {
        return instances.compute(entityClass, (eClass, qFactory) -> qFactory == null ? QFactory.fetch(eClass, scanner) : qFactory);
    }

    Q<E> create(boolean withMappings) {
        return this.create(this.metadata.getTableName(), withMappings);
    }

    private static <E> QFactory<E> fetch(Class<E> entityClass, QEntityScanner scanner) {
        return new QFactory<E>(entityClass, scanner, scanner.scanEntity(entityClass));
    }

    Q<E> create(String variable, boolean withMappings) {
        Q<E> type = new Q<E>(this.entityClass, variable, this.metadata.getSchemaName(), this.metadata.getTableName(), this.scanner);
        this.metadata.getColumns().forEach(type::addColumn);
        if (withMappings) {
            this.metadata.getJoinColumns().forEach(type::addJoinColumn);
            this.metadata.getCompositeJoinColumns().forEach(type::addCompositeJoinColumn);
            this.metadata.getInverseJoinColumns().forEach(type::addInverseJoinColumn);
            this.metadata.getInverseCompositeJoinColumns().forEach(type::addInverseCompositeJoinColumn);
        }
        type.addPrimaryKey(this.metadata.getIdColumns());
        return type;
    }

    public QEntityMetadata getMetadata() {
        return this.metadata;
    }
}

