/*
 * Decompiled with CFR 0.152.
 */
package pl.exsio.querydsl.entityql;

import com.querydsl.core.dml.StoreClause;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.ArrayPath;
import com.querydsl.core.types.dsl.BooleanPath;
import com.querydsl.core.types.dsl.ComparableExpressionBase;
import com.querydsl.core.types.dsl.DatePath;
import com.querydsl.core.types.dsl.DateTimePath;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.core.types.dsl.TimePath;
import com.querydsl.sql.ForeignKey;
import com.querydsl.sql.RelationalPathBase;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import pl.exsio.querydsl.entityql.ex.InvalidArgumentException;
import pl.exsio.querydsl.entityql.path.QEnumPath;
import pl.exsio.querydsl.entityql.path.QUuidPath;

public abstract class QBase<E>
extends RelationalPathBase<E> {
    protected final Map<String, Path<?>> columnsMap = new HashMap();
    protected final Map<String, ForeignKey<?>> joinColumnsMap = new HashMap();
    protected final Map<String, ForeignKey<?>> inverseJoinColumnsMap = new HashMap();

    QBase(Class<? extends E> type, String variable, String schema, String table) {
        super(type, variable, schema, table);
    }

    protected <C extends StoreClause<C>> StoreClause<C> set(StoreClause<C> clause, Function<Object, Path<Object>> pathProvider, Object ... params) {
        if (params.length % 2 != 0) {
            throw new InvalidArgumentException("Odd number of parameters");
        }
        for (int i = 0; i < params.length - 1; i += 2) {
            clause.set(pathProvider.apply(params[i]), params[i + 1]);
        }
        return clause;
    }

    public List<Expression<?>> columns(String ... columns) {
        LinkedList expressions = new LinkedList();
        for (String column : columns) {
            this.checkIfColumnExists(column);
            expressions.add((Expression<?>)this.columns().get(column));
        }
        return expressions;
    }

    public <T extends Enum<T>> QEnumPath<T> enumerated(String fieldName) {
        this.checkIfColumnExists(fieldName);
        return (QEnumPath)this.columns().get(fieldName);
    }

    public QUuidPath uuid(String fieldName) {
        this.checkIfColumnExists(fieldName);
        return (QUuidPath)this.columns().get(fieldName);
    }

    public NumberPath<Long> longNumber(String fieldName) {
        this.checkIfColumnExists(fieldName);
        return (NumberPath)this.columns().get(fieldName);
    }

    public NumberPath<Float> floatNumber(String fieldName) {
        this.checkIfColumnExists(fieldName);
        return (NumberPath)this.columns().get(fieldName);
    }

    public NumberPath<Integer> intNumber(String fieldName) {
        this.checkIfColumnExists(fieldName);
        return (NumberPath)this.columns().get(fieldName);
    }

    public NumberPath<Double> doubleNumber(String fieldName) {
        this.checkIfColumnExists(fieldName);
        return (NumberPath)this.columns().get(fieldName);
    }

    public NumberPath<Byte> byteNumber(String fieldName) {
        this.checkIfColumnExists(fieldName);
        return (NumberPath)this.columns().get(fieldName);
    }

    public NumberPath<Short> shortNumber(String fieldName) {
        this.checkIfColumnExists(fieldName);
        return (NumberPath)this.columns().get(fieldName);
    }

    public NumberPath<BigDecimal> decimalNumber(String fieldName) {
        this.checkIfColumnExists(fieldName);
        return (NumberPath)this.columns().get(fieldName);
    }

    public NumberPath<BigInteger> bigIntNumber(String fieldName) {
        this.checkIfColumnExists(fieldName);
        return (NumberPath)this.columns().get(fieldName);
    }

    public <T extends Number> NumberPath<T> number(String fieldName) {
        this.checkIfColumnExists(fieldName);
        return (NumberPath)this.columns().get(fieldName);
    }

    public StringPath string(String fieldName) {
        this.checkIfColumnExists(fieldName);
        return (StringPath)this.columns().get(fieldName);
    }

    public BooleanPath bool(String fieldName) {
        this.checkIfColumnExists(fieldName);
        return (BooleanPath)this.columns().get(fieldName);
    }

    public DatePath<LocalDate> date(String fieldName) {
        this.checkIfColumnExists(fieldName);
        return (DatePath)this.columns().get(fieldName);
    }

    public <A, AE> ArrayPath<A, AE> array(String fieldName) {
        return (ArrayPath)this.columns().get(fieldName);
    }

    public DateTimePath<LocalDateTime> dateTime(String fieldName) {
        this.checkIfColumnExists(fieldName);
        return (DateTimePath)this.columns().get(fieldName);
    }

    public <T extends Comparable> ComparableExpressionBase<T> comparableColumn(String fieldName) {
        this.checkIfColumnExists(fieldName);
        return (ComparableExpressionBase)this.columns().get(fieldName);
    }

    public <T extends Comparable> Path<T> column(String fieldName) {
        this.checkIfColumnExists(fieldName);
        return this.columns().get(fieldName);
    }

    private void checkIfColumnExists(String fieldName) {
        if (!this.containsColumn(fieldName)) {
            throw new InvalidArgumentException(String.format("No Column with name %s, available columns: %s", fieldName, this.columns().keySet()));
        }
    }

    public <T> ForeignKey<T> joinColumn(String fieldName) {
        if (!this.containsJoinColumn(fieldName)) {
            throw new InvalidArgumentException(String.format("No FK with name %s, available FKs: %s", fieldName, this.joinColumns().keySet()));
        }
        return this.joinColumns().get(fieldName);
    }

    public <T> ForeignKey<T> inverseJoinColumn(String fieldName) {
        if (!this.containsInverseJoinColumn(fieldName)) {
            throw new InvalidArgumentException(String.format("No inverse FK with name %s, available FKs: %s", fieldName, this.inverseJoinColumns().keySet()));
        }
        return this.inverseJoinColumns().get(fieldName);
    }

    public Map<String, Path<?>> columns() {
        return this.columnsMap;
    }

    public Map<String, ForeignKey<?>> joinColumns() {
        return this.joinColumnsMap;
    }

    public Map<String, ForeignKey<?>> inverseJoinColumns() {
        return this.inverseJoinColumnsMap;
    }

    public boolean containsColumn(String fieldName) {
        return this.columnsMap.containsKey(fieldName);
    }

    public boolean containsJoinColumn(String fieldName) {
        return this.joinColumnsMap.containsKey(fieldName);
    }

    public boolean containsInverseJoinColumn(String fieldName) {
        return this.inverseJoinColumnsMap.containsKey(fieldName);
    }

    protected <A, E1> ArrayPath<A, E1> createArray(String property, Class<? super A> type) {
        return super.createArray(property, type);
    }

    protected BooleanPath createBoolean(String property) {
        return super.createBoolean(property);
    }

    protected <A extends Number> NumberPath<A> createNumber(String property, Class<? super A> type) {
        return super.createNumber(property, type);
    }

    protected StringPath createString(String property) {
        return super.createString(property);
    }

    protected <A extends Comparable> DatePath<A> createDate(String property, Class<? super A> type) {
        return super.createDate(property, type);
    }

    protected <A extends Comparable> DateTimePath<A> createDateTime(String property, Class<? super A> type) {
        return super.createDateTime(property, type);
    }

    protected <A> SimplePath<A> createSimple(String property, Class<? super A> type) {
        return super.createSimple(property, type);
    }

    protected <A extends Comparable> TimePath<A> createTime(String property, Class<? super A> type) {
        return super.createTime(property, type);
    }
}

