/*
 * Decompiled with CFR 0.152.
 */
package pl.exsio.querydsl.entityql;

import com.querydsl.core.dml.StoreClause;
import com.querydsl.core.types.Path;
import com.querydsl.sql.ColumnMetadata;
import com.querydsl.sql.ForeignKey;
import com.querydsl.sql.PrimaryKey;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import pl.exsio.querydsl.entityql.QBase;
import pl.exsio.querydsl.entityql.QColumn;
import pl.exsio.querydsl.entityql.QForeignKey;
import pl.exsio.querydsl.entityql.QJoinColumn;
import pl.exsio.querydsl.entityql.QPath;
import pl.exsio.querydsl.entityql.entity.metadata.QEntityColumnMetadata;
import pl.exsio.querydsl.entityql.entity.metadata.QEntityCompositeJoinColumnMetadata;
import pl.exsio.querydsl.entityql.entity.metadata.QEntityJoinColumnMetadata;
import pl.exsio.querydsl.entityql.entity.scanner.QEntityScanner;
import pl.exsio.querydsl.entityql.ex.InvalidArgumentException;

public class Q<E>
extends QBase<E> {
    private final QEntityScanner scanner;
    private final Map<String, QPath> rawColumns = new LinkedHashMap<String, QPath>();
    private final Map<String, QForeignKey> rawJoinColumns = new LinkedHashMap<String, QForeignKey>();
    private final Map<String, QForeignKey> rawInverseJoinColumns = new LinkedHashMap<String, QForeignKey>();
    private PrimaryKey<?> id;
    List<QEntityColumnMetadata> idColumns = new LinkedList<QEntityColumnMetadata>();

    Q(Class<E> type, String variable, String schema, String table, QEntityScanner scanner) {
        super(type, variable, schema, table);
        this.scanner = scanner;
    }

    void addColumn(QEntityColumnMetadata column) {
        QColumn qColumn = new QColumn(this, column);
        this.rawColumns.put(column.getFieldName(), qColumn.getPath());
        this.columnsMap.put(column.getFieldName(), qColumn.getPath().get());
        this.addMetadata(qColumn.getPath().get(), qColumn.getMetadata());
    }

    void addJoinColumn(QEntityJoinColumnMetadata column) {
        QJoinColumn qColumn = new QJoinColumn(this, column, this.scanner, false);
        if (qColumn.getPaths().size() > 1) {
            throw new InvalidArgumentException(String.format("Single JoinColumn mapped to a Composite Primary Key: %s", column.getFieldName()));
        }
        qColumn.getPaths().forEach((path, metadata) -> {
            String idColumnName = String.format("%sId", column.getFieldName());
            this.rawColumns.put(idColumnName, (QPath)path);
            this.columnsMap.put(idColumnName, path.get());
            this.addMetadata((Path)path.get(), (ColumnMetadata)metadata);
            ForeignKey foreignKey = this.createForeignKey(path.get(), qColumn.getForeignColumnNames().getFirst());
            this.rawJoinColumns.put(column.getFieldName(), new QForeignKey(foreignKey, column.getFieldType(), qColumn.getPaths(), qColumn.getForeignColumnNames()));
            this.joinColumnsMap.put(column.getFieldName(), foreignKey);
        });
    }

    void addInverseJoinColumn(QEntityJoinColumnMetadata column) {
        QJoinColumn qColumn = new QJoinColumn(this, column, this.scanner, true);
        if (qColumn.getPaths().size() > 1) {
            throw new InvalidArgumentException(String.format("Single inverse JoinColumn mapped to a Composite Primary Key: %s", column.getFieldName()));
        }
        qColumn.getPaths().forEach((path, metadata) -> {
            this.addMetadata((Path)path.get(), (ColumnMetadata)metadata);
            ForeignKey foreignKey = this.createInvForeignKey(path.get(), qColumn.getForeignColumnNames().getFirst());
            this.rawInverseJoinColumns.put(column.getFieldName(), new QForeignKey(foreignKey, column.getFieldType(), qColumn.getPaths(), qColumn.getForeignColumnNames()));
            this.inverseJoinColumnsMap.put(column.getFieldName(), foreignKey);
        });
    }

    void addCompositeJoinColumn(QEntityCompositeJoinColumnMetadata column) {
        QJoinColumn qColumn = new QJoinColumn(this, column, this.scanner, false);
        qColumn.getPaths().forEach((path, metadata) -> this.addMetadata((Path)path.get(), (ColumnMetadata)metadata));
        ForeignKey foreignKey = this.createForeignKey(this.getPaths(qColumn), qColumn.getForeignColumnNames());
        this.rawJoinColumns.put(column.getFieldName(), new QForeignKey(foreignKey, column.getFieldType(), qColumn.getPaths(), qColumn.getForeignColumnNames()));
        this.joinColumnsMap.put(column.getFieldName(), foreignKey);
    }

    void addInverseCompositeJoinColumn(QEntityCompositeJoinColumnMetadata column) {
        QJoinColumn qColumn = new QJoinColumn(this, column, this.scanner, true);
        qColumn.getPaths().forEach((path, metadata) -> this.addMetadata((Path)path.get(), (ColumnMetadata)metadata));
        ForeignKey foreignKey = this.createInvForeignKey(this.getPaths(qColumn), qColumn.getForeignColumnNames());
        this.rawInverseJoinColumns.put(column.getFieldName(), new QForeignKey(foreignKey, column.getFieldType(), qColumn.getPaths(), qColumn.getForeignColumnNames()));
        this.inverseJoinColumnsMap.put(column.getFieldName(), foreignKey);
    }

    private List<Path<?>> getPaths(QJoinColumn qColumn) {
        return qColumn.getPaths().keySet().stream().map(QPath::get).collect(Collectors.toList());
    }

    void addPrimaryKey(List<QEntityColumnMetadata> ids) {
        this.idColumns = ids;
        List pkColumnNames = ids.stream().map(QEntityColumnMetadata::getFieldName).collect(Collectors.toList());
        Path[] pkPaths = (Path[])this.rawColumns.entrySet().stream().filter(e -> pkColumnNames.contains(e.getKey())).map(e -> ((QPath)e.getValue()).get()).toArray(Path[]::new);
        this.id = this.createPrimaryKey(pkPaths);
    }

    protected <P extends Path<?>> P addMetadata(P path, ColumnMetadata metadata) {
        return (P)super.addMetadata(path, metadata);
    }

    public <C extends StoreClause<C>> StoreClause<C> set(StoreClause<C> clause, Object ... params) {
        return super.set(clause, (Object key) -> {
            if (!(key instanceof String)) {
                throw new InvalidArgumentException("Param key has to be String");
            }
            return this.rawColumns.get(key).get();
        }, params);
    }

    public Map<String, QPath> rawColumns() {
        return this.rawColumns;
    }

    public Map<String, QForeignKey> rawJoinColumns() {
        return this.rawJoinColumns;
    }

    public Map<String, QForeignKey> rawInverseJoinColumns() {
        return this.rawInverseJoinColumns;
    }

    public PrimaryKey<E> primaryKey() {
        return this.id;
    }
}

