/*
 * Decompiled with CFR 0.152.
 */
package pl.exsio.querydsl.entityql;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.internal.file.UnionFileCollection;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import pl.exsio.querydsl.entityql.GeneratePluginExtension;
import pl.exsio.querydsl.entityql.GenerateTask;

public class GeneratePlugin
implements Plugin<Project> {
    private static final String EXTENSION_NAME = "entityql";
    private static final String TASK_NAME = "generateModels";

    public void apply(Project project) {
        GeneratePluginExtension generatePluginExtension = (GeneratePluginExtension)project.getExtensions().create(EXTENSION_NAME, GeneratePluginExtension.class, new Object[]{project});
        GenerateTask generateTask = (GenerateTask)project.getTasks().create(TASK_NAME, GenerateTask.class);
        generateTask.setGroup("build");
        generateTask.setDescription("Generates EntityQL Static Query Models.");
        generateTask.setExtension(generatePluginExtension);
        generateTask.setBaseDir(project.getProjectDir());
        project.afterEvaluate(evaluatedProject -> {
            Set<File> paths;
            SourceSetContainer sourceSets = (SourceSetContainer)project.getProperties().get("sourceSets");
            if (sourceSets != null) {
                UnionFileCollection mainClasspath = (UnionFileCollection)((SourceSet)sourceSets.getByName("main")).getRuntimeClasspath();
                paths = mainClasspath.getFiles();
            } else {
                paths = new HashSet<File>();
            }
            generateTask.setSourcePaths(paths);
        });
    }
}

