/*
 * Decompiled with CFR 0.152.
 */
package com.github.dzieciou.testing.curl;

import com.github.dzieciou.testing.curl.CurlGeneratingInterceptor;
import com.github.dzieciou.testing.curl.CurlHandler;
import com.github.dzieciou.testing.curl.CurlLogger;
import com.github.dzieciou.testing.curl.Options;
import io.restassured.config.HttpClientConfig;
import io.restassured.config.RestAssuredConfig;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.AbstractHttpClient;

public class CurlRestAssuredConfigFactory {
    public static RestAssuredConfig createConfig() {
        return CurlRestAssuredConfigFactory.createConfig(CurlRestAssuredConfigFactory.getDefaultOptions());
    }

    public static RestAssuredConfig createConfig(Options options) {
        return CurlRestAssuredConfigFactory.updateConfig(RestAssuredConfig.config(), options);
    }

    public static RestAssuredConfig createConfig(Options options, List<CurlHandler> handlers) {
        return CurlRestAssuredConfigFactory.updateConfig(RestAssuredConfig.config(), options, handlers);
    }

    public static RestAssuredConfig createConfig(List<CurlHandler> handlers) {
        return CurlRestAssuredConfigFactory.updateConfig(RestAssuredConfig.config(), handlers);
    }

    public static RestAssuredConfig updateConfig(RestAssuredConfig config) {
        return CurlRestAssuredConfigFactory.updateConfig(config, CurlRestAssuredConfigFactory.getDefaultOptions(), CurlRestAssuredConfigFactory.getDefaultHandlers());
    }

    public static RestAssuredConfig updateConfig(RestAssuredConfig config, Options options) {
        return CurlRestAssuredConfigFactory.updateConfig(config, options, CurlRestAssuredConfigFactory.getDefaultHandlers());
    }

    public static RestAssuredConfig updateConfig(RestAssuredConfig config, List<CurlHandler> handlers) {
        return CurlRestAssuredConfigFactory.updateConfig(config, CurlRestAssuredConfigFactory.getDefaultOptions(), handlers);
    }

    public static RestAssuredConfig updateConfig(RestAssuredConfig config, Options options, List<CurlHandler> handlers) {
        HttpClientConfig.HttpClientFactory originalFactory = CurlRestAssuredConfigFactory.getHttpClientFactory(config);
        CurlGeneratingInterceptor interceptor = new CurlGeneratingInterceptor(options, handlers);
        return config.httpClient(config.getHttpClientConfig().dontReuseHttpClientInstance().httpClientFactory((HttpClientConfig.HttpClientFactory)new MyHttpClientFactory(originalFactory, interceptor)));
    }

    private static Options getDefaultOptions() {
        return Options.builder().dontLogStacktrace().printSingleliner().useShortForm().escapeNonAscii().build();
    }

    private static List<CurlHandler> getDefaultHandlers() {
        return Arrays.asList(new CurlLogger());
    }

    private static HttpClientConfig.HttpClientFactory getHttpClientFactory(RestAssuredConfig config) {
        try {
            Field f = HttpClientConfig.class.getDeclaredField("httpClientFactory");
            f.setAccessible(true);
            HttpClientConfig httpClientConfig = config.getHttpClientConfig();
            HttpClientConfig.HttpClientFactory httpClientFactory = (HttpClientConfig.HttpClientFactory)f.get(httpClientConfig);
            f.setAccessible(false);
            return httpClientFactory;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private static class MyHttpClientFactory
    implements HttpClientConfig.HttpClientFactory {
        private final HttpClientConfig.HttpClientFactory wrappedFactory;
        private final CurlGeneratingInterceptor curlGeneratingInterceptor;

        public MyHttpClientFactory(HttpClientConfig.HttpClientFactory wrappedFactory, CurlGeneratingInterceptor curlGeneratingInterceptor) {
            this.wrappedFactory = wrappedFactory;
            this.curlGeneratingInterceptor = curlGeneratingInterceptor;
        }

        public HttpClient createHttpClient() {
            AbstractHttpClient client = (AbstractHttpClient)this.wrappedFactory.createHttpClient();
            client.addRequestInterceptor((HttpRequestInterceptor)this.curlGeneratingInterceptor);
            return client;
        }
    }
}

