/*
 * Decompiled with CFR 0.152.
 */
package com.github.dwhjames.awswrap.dynamodb;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.retry.RetryUtils;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult;
import com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\u0001\u0003\u00015\u0011\u0011dU5oO2,G\u000b\u001b:fC\u0012,GMQ1uG\"<&/\u001b;fe*\u00111\u0001B\u0001\tIft\u0017-\\8eE*\u0011QAB\u0001\bC^\u001cxO]1q\u0015\t9\u0001\"\u0001\u0005eo\"T\u0017-\\3t\u0015\tI!\"\u0001\u0004hSRDWO\u0019\u0006\u0002\u0017\u0005\u00191m\\7\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\t\u0011U\u0001!Q1A\u0005\u0002Y\t\u0011\u0002^1cY\u0016t\u0015-\\3\u0016\u0003]\u0001\"\u0001G\u000e\u000f\u0005=I\u0012B\u0001\u000e\u0011\u0003\u0019\u0001&/\u001a3fM&\u0011A$\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005i\u0001\u0002\u0002C\u0010\u0001\u0005\u0003\u0005\u000b\u0011B\f\u0002\u0015Q\f'\r\\3OC6,\u0007\u0005\u0003\u0005\"\u0001\t\u0015\r\u0011\"\u0001#\u0003M\u0019'/\u001a3f]RL\u0017\r\\:Qe>4\u0018\u000eZ3s+\u0005\u0019\u0003C\u0001\u0013*\u001b\u0005)#B\u0001\u0014(\u0003\u0011\tW\u000f\u001e5\u000b\u0005!R\u0011!C1nCj|g.Y<t\u0013\tQSE\u0001\fB/N\u001b%/\u001a3f]RL\u0017\r\\:Qe>4\u0018\u000eZ3s\u0011!a\u0003A!A!\u0002\u0013\u0019\u0013\u0001F2sK\u0012,g\u000e^5bYN\u0004&o\u001c<jI\u0016\u0014\b\u0005C\u0003/\u0001\u0011\u0005q&\u0001\u0004=S:LGO\u0010\u000b\u0004aI\u001a\u0004CA\u0019\u0001\u001b\u0005\u0011\u0001\"B\u000b.\u0001\u00049\u0002\"B\u0011.\u0001\u0004\u0019S\u0001B\u001b\u0001\tY\u0012QAQ1uG\"\u0004Ba\u000e\u001f\u0018}5\t\u0001H\u0003\u0002:u\u0005!Q\u000f^5m\u0015\u0005Y\u0014\u0001\u00026bm\u0006L!!\u0010\u001d\u0003\u00075\u000b\u0007\u000fE\u00028\u007f\u0005K!\u0001\u0011\u001d\u0003\t1K7\u000f\u001e\t\u0003\u0005&k\u0011a\u0011\u0006\u0003\t\u0016\u000bQ!\\8eK2T!AR$\u0002\u0015\u0011Lh.Y7pI\n4(G\u0003\u0002IO\u0005A1/\u001a:wS\u000e,7/\u0003\u0002K\u0007\naqK]5uKJ+\u0017/^3ti\"9A\n\u0001b\u0001\n\u0013i\u0015A\u00027pO\u001e,'/F\u0001O!\tyE+D\u0001Q\u0015\t\t&+A\u0003tY\u001a$$NC\u0001T\u0003\ry'oZ\u0005\u0003+B\u0013a\u0001T8hO\u0016\u0014\bBB,\u0001A\u0003%a*A\u0004m_\u001e<WM\u001d\u0011\t\u000fe\u0003!\u0019!C\u00015\u000611\r\\5f]R,\u0012a\u0017\t\u00039vk\u0011!R\u0005\u0003=\u0016\u0013A#Q7bu>tG)\u001f8b[>$%i\u00117jK:$\bB\u00021\u0001A\u0003%1,A\u0004dY&,g\u000e\u001e\u0011\t\u000b9\u0002A\u0011\u00012\u0015\u0007A\u001aG\rC\u0003\u0016C\u0002\u0007q\u0003C\u0003fC\u0002\u0007a-A\u0006de\u0016$WM\u001c;jC2\u001c\bC\u0001\u0013h\u0013\tAWE\u0001\bB/N\u001b%/\u001a3f]RL\u0017\r\\:\t\u000b)\u0004A\u0011B6\u0002\u000bA\fWo]3\u0015\u00051|\u0007CA\bn\u0013\tq\u0007C\u0001\u0003V]&$\b\"\u00029j\u0001\u0004\t\u0018a\u0002:fiJLWm\u001d\t\u0003\u001fIL!a\u001d\t\u0003\u0007%sG\u000fC\u0003v\u0001\u0011%a/A\u000bxe&$XmV5uQ\n\u000b7m[8gMJ+GO]=\u0015\u0005]l\b\u0003B\bycjL!!\u001f\t\u0003\rQ+\b\u000f\\33!\ty10\u0003\u0002}!\t1Ai\\;cY\u0016DQA ;A\u0002}\fQAY1uG\"\u00042!!\u00015\u001b\u0005\u0001\u0001bBA\u0003\u0001\u0011%\u0011qA\u0001\b[.\u0014\u0015\r^2i)\ry\u0018\u0011\u0002\u0005\b\u0003\u0017\t\u0019\u00011\u0001?\u0003!\u0011X-];fgR\u001c\bbBA\b\u0001\u0011\u0005\u0011\u0011C\u0001\u0004eVtGc\u00017\u0002\u0014!A\u0011QCA\u0007\u0001\u0004\t9\"\u0001\u0004t_V\u00148-\u001a\t\u0006\u00033\tI#\u0011\b\u0005\u00037\t)C\u0004\u0003\u0002\u001e\u0005\rRBAA\u0010\u0015\r\t\t\u0003D\u0001\u0007yI|w\u000e\u001e \n\u0003EI1!a\n\u0011\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u000b\u0002.\tA\u0011\n^3sCR|'OC\u0002\u0002(A\u0001")
public class SingleThreadedBatchWriter {
    private final String tableName;
    private final AWSCredentialsProvider credentialsProvider;
    private final Logger logger;
    private final AmazonDynamoDBClient client;

    public String tableName() {
        return this.tableName;
    }

    public AWSCredentialsProvider credentialsProvider() {
        return this.credentialsProvider;
    }

    private Logger logger() {
        return this.logger;
    }

    public AmazonDynamoDBClient client() {
        return this.client;
    }

    private void pause(int retries) {
        if (retries > 0) {
            long delay = (long)(package$.MODULE$.pow(2.0, (double)(retries - 1)) * 50.0);
            this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"backing off for ", " msecs."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)delay)})));
            Thread.sleep(delay);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Tuple2<Object, Object> writeWithBackoffRetry(Map<String, List<WriteRequest>> batch) {
        int retries = 0;
        double consumedCapacity = 0.0;
        Map batchRemaining = batch;
        while (batchRemaining.size() > 0) {
            this.pause(retries);
            {
                BatchWriteItemRequest request = new BatchWriteItemRequest().withRequestItems(batchRemaining).withReturnConsumedCapacity(ReturnConsumedCapacity.TOTAL);
                this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"attempt ", ": writing ", " items to table ", " in batch ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(++retries)), BoxesRunTime.boxToInteger((int)batchRemaining.get(this.tableName()).size()), this.tableName(), BoxesRunTime.boxToInteger((int)((Object)batchRemaining).hashCode())})));
                BatchWriteItemResult result = this.client().batchWriteItem(request);
                Double capacityConsumedByRequest = ((ConsumedCapacity)result.getConsumedCapacity().get(0)).getCapacityUnits();
                this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"consumed capacity: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{capacityConsumedByRequest})));
                consumedCapacity += Predef$.MODULE$.Double2double(capacityConsumedByRequest);
                batchRemaining = result.getUnprocessedItems();
                if (batchRemaining.size() <= 0) continue;
                this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " items were unprocessed in attempt ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((List)batchRemaining.get(this.tableName())).size()), BoxesRunTime.boxToInteger((int)retries)})));
                continue;
            }
            break;
        }
        return new Tuple2.mcID.sp(retries, consumedCapacity);
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, List<WriteRequest>> mkBatch(List<WriteRequest> requests) {
        void var2_2;
        HashMap<String, List<WriteRequest>> m = new HashMap<String, List<WriteRequest>>(1);
        m.put(this.tableName(), requests);
        return var2_2;
    }

    public void run(Iterator<WriteRequest> source) {
        Random rnd = new Random();
        int pauseIncrement = 25;
        int batchSize = 2;
        int pauseDuration = pauseIncrement;
        long startOfLastSuccessfulWrite = System.nanoTime();
        double averagedThroughput = 0.0;
        long sampleStartTime = startOfLastSuccessfulWrite;
        int numOfSamplesTaken = 0;
        double consumedCapacitySampleSum = 0.0;
        while (source.hasNext()) {
            this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"pausing for ", " msecs."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)pauseDuration)})));
            Thread.sleep(pauseDuration);
            ArrayList<WriteRequest> writeRequests = new ArrayList<WriteRequest>(batchSize);
            for (int i = 0; source.hasNext() && i < batchSize; ++i) {
                writeRequests.add((WriteRequest)source.next());
            }
            Map<String, List<WriteRequest>> batch = this.mkBatch(writeRequests);
            Tuple2 tuple2 = this.liftedTree1$1(batch);
            if (tuple2 != null) {
                Tuple2.mcID.sp sp2;
                int attempts = tuple2._1$mcI$sp();
                double consumedCapacity = tuple2._2$mcD$sp();
                Tuple2.mcID.sp sp3 = sp2 = new Tuple2.mcID.sp(attempts, consumedCapacity);
                int attempts2 = sp3._1$mcI$sp();
                double consumedCapacity2 = sp3._2$mcD$sp();
                long afterSuccessfulWrite = System.nanoTime();
                double estimatedTime = (double)(afterSuccessfulWrite - startOfLastSuccessfulWrite) / 1.0E9;
                startOfLastSuccessfulWrite = afterSuccessfulWrite;
                double estimatedThroughput = consumedCapacity2 / estimatedTime;
                averagedThroughput = 0.9 * averagedThroughput + 0.1 * estimatedThroughput;
                numOfSamplesTaken = (numOfSamplesTaken + 1) % 10;
                consumedCapacitySampleSum += consumedCapacity2;
                if (numOfSamplesTaken == 0) {
                    double estimatedSampleTime = (double)(afterSuccessfulWrite - sampleStartTime) / 1.0E9;
                    sampleStartTime = afterSuccessfulWrite;
                    double sampleThroughput = consumedCapacitySampleSum / estimatedSampleTime;
                    consumedCapacitySampleSum = 0.0;
                    this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throughput sampled over last 10 batches is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)sampleThroughput)})));
                }
                this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " attempts required to write batch ", ", consumed ", " capacity, estimated throughput ", ", average throughput ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)attempts2), BoxesRunTime.boxToInteger((int)((Object)batch).hashCode()), BoxesRunTime.boxToDouble((double)consumedCapacity2), BoxesRunTime.boxToDouble((double)estimatedThroughput), BoxesRunTime.boxToDouble((double)averagedThroughput)})));
                if (attempts2 > 1) {
                    if (pauseDuration > 500 || rnd.nextDouble() < 0.05) {
                        batchSize = package$.MODULE$.max(2, batchSize - 1);
                        this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"decreasing batch size to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)batchSize)})));
                        continue;
                    }
                    pauseDuration += pauseIncrement;
                    this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"increasing pause by ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)pauseIncrement)})));
                    continue;
                }
                if ((pauseDuration = package$.MODULE$.max(0, pauseDuration - 1)) != 0 && !(rnd.nextDouble() < 0.05)) continue;
                batchSize = package$.MODULE$.min(25, batchSize + 1);
                this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"increasing batch size to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)batchSize)})));
                continue;
            }
            throw new MatchError((Object)tuple2);
        }
    }

    private final Tuple2 liftedTree1$1(Map batch$1) {
        Throwable throwable2;
        block2: {
            Tuple2<Object, Object> tuple2;
            block3: {
                Tuple2<Object, Object> tuple22;
                block4: {
                    Tuple2.mcID.sp sp2;
                    try {
                        sp2 = this.writeWithBackoffRetry(batch$1);
                    }
                    catch (Throwable throwable2) {
                        Tuple2.mcID.sp sp3;
                        Tuple2.mcID.sp sp4;
                        Tuple2.mcID.sp sp5;
                        AmazonServiceException amazonServiceException;
                        Throwable throwable3 = throwable2;
                        if (!(throwable3 instanceof AmazonServiceException) || !RetryUtils.isRequestEntityTooLargeException((AmazonServiceException)(amazonServiceException = (AmazonServiceException)throwable3))) break block2;
                        List requests = (List)batch$1.get(this.tableName());
                        int size = requests.size();
                        int mid = size / 2;
                        this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"batch exceeded the request size limit! ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{batch$1})));
                        tuple2 = this.writeWithBackoffRetry(this.mkBatch(requests.subList(0, mid)));
                        if (tuple2 == null) break block3;
                        int f_attempts = tuple2._1$mcI$sp();
                        double f_consumed = tuple2._2$mcD$sp();
                        Tuple2.mcID.sp sp6 = sp5 = new Tuple2.mcID.sp(f_attempts, f_consumed);
                        int f_attempts2 = sp6._1$mcI$sp();
                        double f_consumed2 = sp6._2$mcD$sp();
                        tuple22 = this.writeWithBackoffRetry(this.mkBatch(requests.subList(mid, size)));
                        if (tuple22 == null) break block4;
                        int s_attempts = tuple22._1$mcI$sp();
                        double s_consumed = tuple22._2$mcD$sp();
                        Tuple2.mcID.sp sp7 = sp4 = new Tuple2.mcID.sp(s_attempts, s_consumed);
                        int s_attempts2 = sp7._1$mcI$sp();
                        double s_consumed2 = sp7._2$mcD$sp();
                        sp2 = sp3 = new Tuple2.mcID.sp(package$.MODULE$.max(f_attempts2, s_attempts2), f_consumed2 + s_consumed2);
                    }
                    return sp2;
                }
                throw new MatchError(tuple22);
            }
            throw new MatchError(tuple2);
        }
        throw throwable2;
    }

    public SingleThreadedBatchWriter(String tableName, AWSCredentialsProvider credentialsProvider) {
        this.tableName = tableName;
        this.credentialsProvider = credentialsProvider;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.client = new AmazonDynamoDBClient(credentialsProvider, new ClientConfiguration().withMaxErrorRetry(0));
    }

    public SingleThreadedBatchWriter(String tableName, AWSCredentials credentials) {
        this(tableName, (AWSCredentialsProvider)new StaticCredentialsProvider(credentials));
    }
}

