/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk;

import com.herewhite.sdk.domain.CameraBound;
import com.herewhite.sdk.domain.MemberInformation;
import com.herewhite.sdk.domain.Region;
import com.herewhite.sdk.domain.WhiteObject;
import com.herewhite.sdk.domain.WindowParams;
import java.util.concurrent.TimeUnit;

public class RoomParams
extends WhiteObject {
    private String uuid;
    private String roomToken;
    private Region region;
    private CameraBound cameraBound;
    private long timeout = 45000L;
    private boolean isWritable = true;
    private boolean disableEraseImage = false;
    private boolean disableDeviceInputs = false;
    private boolean disableOperations = false;
    private boolean disableCameraTransform = false;
    private boolean disableBezier = false;
    private boolean disableNewPencil = true;
    private Object userPayload;
    private Boolean useMultiViews = false;
    private WindowParams windowParams;

    public void setRegion(Region region) {
        this.region = region;
    }

    public Region getRegion() {
        return this.region;
    }

    public boolean isWritable() {
        return this.isWritable;
    }

    public void setWritable(boolean writable) {
        this.isWritable = writable;
    }

    public boolean getDisableEraseImage() {
        return this.disableEraseImage;
    }

    public void setDisableEraseImage(boolean disableEraseImage) {
        this.disableEraseImage = disableEraseImage;
    }

    public void setTimeout(long timeout, TimeUnit timeUnit) {
        this.timeout = TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
    }

    public boolean isDisableDeviceInputs() {
        return this.disableDeviceInputs;
    }

    public void setDisableDeviceInputs(boolean disableDeviceInputs) {
        this.disableDeviceInputs = disableDeviceInputs;
    }

    public boolean isDisableOperations() {
        return this.disableOperations;
    }

    public void setDisableOperations(boolean disableOperations) {
        this.disableCameraTransform = disableOperations;
        this.disableDeviceInputs = disableOperations;
        this.disableOperations = disableOperations;
    }

    public boolean isDisableBezier() {
        return this.disableBezier;
    }

    public void setDisableBezier(boolean disableBezier) {
        this.disableBezier = disableBezier;
    }

    public boolean isDisableCameraTransform() {
        return this.disableCameraTransform;
    }

    public void setDisableCameraTransform(boolean disableCameraTransform) {
        this.disableCameraTransform = disableCameraTransform;
    }

    public boolean isDisableNewPencil() {
        return this.disableNewPencil;
    }

    public void setDisableNewPencil(boolean disableNewPencil) {
        this.disableNewPencil = disableNewPencil;
    }

    public CameraBound getCameraBound() {
        return this.cameraBound;
    }

    public void setCameraBound(CameraBound cameraBound) {
        this.cameraBound = cameraBound;
    }

    public Object getUserPayload() {
        return this.userPayload;
    }

    public void setUserPayload(Object userPayload) {
        this.userPayload = userPayload;
    }

    public RoomParams(String uuid, String roomToken) {
        this(uuid, roomToken, (Object)null);
    }

    @Deprecated
    public RoomParams(String uuid, String roomToken, MemberInformation memberInfo) {
        this.uuid = uuid;
        this.roomToken = roomToken;
        this.userPayload = memberInfo;
    }

    public RoomParams(String uuid, String roomToken, Object userPayload) {
        this.uuid = uuid;
        this.roomToken = roomToken;
        this.userPayload = userPayload;
    }

    @Deprecated
    public MemberInformation getMemberInfo() {
        if (this.userPayload instanceof MemberInformation) {
            return (MemberInformation)this.userPayload;
        }
        return null;
    }

    @Deprecated
    public void setMemberInfo(MemberInformation memberInfo) {
        this.userPayload = memberInfo;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getRoomToken() {
        return this.roomToken;
    }

    public void setRoomToken(String roomToken) {
        this.roomToken = roomToken;
    }

    public Boolean getUseMultiViews() {
        return this.useMultiViews;
    }

    public void setUseMultiViews(Boolean useMultiViews) {
        this.useMultiViews = useMultiViews;
    }

    public WindowParams getWindowParams() {
        return this.windowParams;
    }

    public void setWindowParams(WindowParams windowParams) {
        this.windowParams = windowParams;
    }
}

