/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk.Utils;

import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.herewhite.sdk.WhiteSdk;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class PreFetcher {
    static final String API_Origin = "https://cloudcapiv4.herewhite.com";
    static final String ORIGINS = "origins";
    static final String PING_INFO_ORIGIN = "origin";
    static final String PING_INFO_PING = "ping";
    static final String PING_INFO_VALID = "valid";
    private static final String TAG = "prefetch";
    static ExecutorService poolExecutor = Executors.newSingleThreadExecutor();
    OkHttpClient client = new OkHttpClient();
    Gson gson = new Gson();
    HashMap<String, Number> responseSpeedMap = new HashMap();
    HashSet<String> domains;
    JsonObject sdkStructConfig;
    JsonObject sdkConfig;
    ResultCallback resultCallback;

    public void setResultCallback(ResultCallback resultCallback) {
        this.resultCallback = resultCallback;
    }

    public void fetchOriginConfigs() {
        Request request = new Request.Builder().url("https://cloudcapiv4.herewhite.com/configs/origin").header("Content-Type", "application/json").header("Accept", "application/json").header("platform", "android").header("version", WhiteSdk.Version()).build();
        Call call = this.client.newCall(request);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                if (PreFetcher.this.resultCallback != null) {
                    PreFetcher.this.resultCallback.fetchOriginConfigFail(e);
                }
            }

            public void onResponse(Call call, Response response) throws IOException {
                JsonObject json = (JsonObject)PreFetcher.this.gson.fromJson(response.body().string(), JsonObject.class);
                JsonObject serverConfig = json.getAsJsonObject("msg");
                if (response.code() == 200) {
                    PreFetcher.this.sdkStructConfig = PreFetcher.this.sdkStructConfig(serverConfig);
                    PreFetcher.this.domains = PreFetcher.this.extractDomains(serverConfig);
                    if (PreFetcher.this.resultCallback != null) {
                        PreFetcher.this.resultCallback.fetchOriginConfigSuccess(serverConfig);
                    }
                    PreFetcher.this.prefetchOrigins();
                } else if (PreFetcher.this.resultCallback != null) {
                    Exception e = new Exception(serverConfig.toString());
                    PreFetcher.this.resultCallback.fetchOriginConfigFail(e);
                }
            }
        });
    }

    public void prefetchOrigins() {
        poolExecutor.execute(new Runnable(){

            @Override
            public void run() {
                for (final String origin : PreFetcher.this.domains) {
                    final CountDownLatch latch = new CountDownLatch(1);
                    final Date beginDate = new Date();
                    PreFetcher.this.pingHost(origin, new Callback(){

                        public void onFailure(Call call, IOException e) {
                            latch.countDown();
                        }

                        public void onResponse(Call call, Response response) throws IOException {
                            double duration = new Date().getTime() - beginDate.getTime();
                            if (response.code() == 200) {
                                Log.i((String)PreFetcher.TAG, (String)("onResponse: " + response.body().string()));
                                PreFetcher.this.responseSpeedMap.put(origin, duration / 1000.0);
                            } else {
                                Log.i((String)PreFetcher.TAG, (String)("ping fail origin: " + origin));
                            }
                            latch.countDown();
                        }
                    });
                    try {
                        latch.await();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                PreFetcher.this.sdkConfig = PreFetcher.this.generateSdkConfig(PreFetcher.this.sdkStructConfig);
                if (PreFetcher.this.resultCallback != null) {
                    PreFetcher.this.resultCallback.finishPrefetch(PreFetcher.this.sdkConfig);
                }
            }
        });
    }

    public JsonObject sdkStructConfig(JsonObject jsonObject) {
        JsonObject structJson = new JsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            JsonElement value = (JsonElement)entry.getValue();
            if (value.isJsonObject()) {
                JsonObject subStructJson = new JsonObject();
                JsonObject originConfig = new JsonObject();
                JsonObject subJson = (JsonObject)value;
                for (Map.Entry subEntry : subJson.entrySet()) {
                    JsonElement subValue = (JsonElement)subEntry.getValue();
                    if (subValue.isJsonPrimitive()) {
                        subStructJson.add((String)subEntry.getKey(), subValue);
                        continue;
                    }
                    originConfig.add((String)subEntry.getKey(), subValue);
                }
                subStructJson.add(ORIGINS, (JsonElement)originConfig);
                structJson.add((String)entry.getKey(), (JsonElement)subStructJson);
                continue;
            }
            structJson.add((String)entry.getKey(), value);
        }
        return structJson;
    }

    public HashSet<String> extractDomains(JsonObject jsonObject) {
        HashSet<String> set = new HashSet<String>();
        for (Map.Entry entry : jsonObject.entrySet()) {
            JsonElement value = (JsonElement)entry.getValue();
            if (value.isJsonPrimitive()) {
                String host;
                JsonPrimitive primitive = (JsonPrimitive)value;
                if (!primitive.isString() || !this.isDomain(host = primitive.getAsString())) continue;
                set.add(primitive.getAsString());
                continue;
            }
            if (value.isJsonObject()) {
                JsonObject subJson = (JsonObject)value;
                set.addAll(this.extractDomains(subJson));
                continue;
            }
            if (!value.isJsonArray()) continue;
            JsonArray array = (JsonArray)value;
            for (int i = 0; i < array.size(); ++i) {
                String host;
                JsonPrimitive primitive;
                JsonElement object = array.get(i);
                if (!object.isJsonPrimitive() || !(primitive = (JsonPrimitive)object).isString() || !this.isDomain(host = primitive.getAsString())) continue;
                set.add(primitive.getAsString());
            }
        }
        return set;
    }

    private boolean isDomain(String url) {
        return url.contains("://");
    }

    public JsonObject generateSdkConfig(JsonObject structObject) {
        JsonObject config = new JsonObject();
        for (Map.Entry entry : structObject.entrySet()) {
            JsonElement value = (JsonElement)entry.getValue();
            if (value.isJsonObject()) {
                JsonObject subStructJson = (JsonObject)value.deepCopy();
                JsonObject oldOrigins = value.getAsJsonObject().get(ORIGINS).getAsJsonObject();
                JsonObject newOrigins = new JsonObject();
                for (Map.Entry subEntry : oldOrigins.entrySet()) {
                    JsonElement subValue = (JsonElement)subEntry.getValue();
                    String subKey = (String)subEntry.getKey();
                    if (subValue.isJsonArray()) {
                        newOrigins.add(subKey, (JsonElement)this.pingInfoHosts(subValue.getAsJsonArray()));
                        continue;
                    }
                    newOrigins.add(subKey, subValue);
                }
                subStructJson.add(ORIGINS, (JsonElement)newOrigins);
                config.add((String)entry.getKey(), (JsonElement)subStructJson);
                continue;
            }
            config.add((String)entry.getKey(), value);
        }
        return config;
    }

    public JsonArray pingInfoHosts(JsonArray hosts) {
        JsonArray jsonArray = new JsonArray();
        for (JsonElement element : hosts) {
            if (!element.isJsonPrimitive()) continue;
            jsonArray.add((JsonElement)this.pingInfoHost(element.getAsString()));
        }
        return jsonArray;
    }

    public JsonObject pingInfoHost(String host) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(PING_INFO_ORIGIN, host);
        boolean contain = this.responseSpeedMap.containsKey(host);
        if (contain) {
            jsonObject.addProperty(PING_INFO_PING, this.responseSpeedMap.get(host));
            jsonObject.addProperty(PING_INFO_VALID, Boolean.valueOf(true));
        } else {
            jsonObject.addProperty(PING_INFO_PING, (Number)10000.0);
            jsonObject.addProperty(PING_INFO_VALID, Boolean.valueOf(false));
        }
        return jsonObject;
    }

    public void pingHost(String origin, Callback callback) {
        Request request = new Request.Builder().url(origin + "/ping").header("platform", "android").header("version", WhiteSdk.Version()).build();
        this.client.newCall(request).enqueue(callback);
    }

    public static interface ResultCallback {
        public void fetchOriginConfigFail(Exception var1);

        public void fetchOriginConfigSuccess(JsonObject var1);

        public void finishPrefetch(JsonObject var1);
    }
}

