/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk;

import android.content.Context;
import android.os.Handler;
import android.webkit.JavascriptInterface;
import com.google.gson.Gson;
import com.herewhite.sdk.Logger;
import com.herewhite.sdk.Room;
import com.herewhite.sdk.RoomCallbacks;
import com.herewhite.sdk.SyncDisplayerState;
import com.herewhite.sdk.domain.EventEntry;
import com.herewhite.sdk.domain.FrameError;
import com.herewhite.sdk.domain.RoomPhase;
import com.herewhite.sdk.domain.RoomState;

public class RoomCallbacksImplement
implements SyncDisplayerState.Listener<RoomState> {
    private static final Gson gson = new Gson();
    private final Handler handler;
    private RoomCallbacks listener;
    private Room room;

    RoomCallbacksImplement(Context context) {
        this.handler = new Handler(context.getMainLooper());
    }

    public RoomCallbacks getListener() {
        return this.listener;
    }

    public void setListener(RoomCallbacks listener) {
        this.listener = listener;
    }

    public void setRoom(Room room) {
        this.room = room;
        this.room.getSyncRoomState().setListener(this);
    }

    @Override
    public void onDisplayerStateChanged(final RoomState modifyState) {
        if (this.listener != null) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    if (RoomCallbacksImplement.this.listener != null) {
                        RoomCallbacksImplement.this.listener.onRoomStateChanged(modifyState);
                    }
                }
            });
        }
    }

    @JavascriptInterface
    public void fireMagixEvent(Object args) {
        EventEntry eventEntry = (EventEntry)gson.fromJson(String.valueOf(args), EventEntry.class);
        if (this.room != null) {
            this.room.fireMagixEvent(eventEntry);
        }
    }

    @JavascriptInterface
    public void fireHighFrequencyEvent(Object args) {
        EventEntry[] events = (EventEntry[])gson.fromJson(String.valueOf(args), EventEntry[].class);
        if (this.room != null) {
            this.room.fireHighFrequencyEvent(events);
        }
    }

    @JavascriptInterface
    public void firePhaseChanged(Object args) {
        RoomPhase phase = RoomPhase.valueOf(String.valueOf(args));
        if (this.room != null) {
            this.room.setRoomPhase(phase);
        }
        if (this.listener != null) {
            try {
                this.listener.onPhaseChanged(phase);
            }
            catch (AssertionError a) {
                throw a;
            }
            catch (Throwable e) {
                Logger.error("An exception occurred while invoke onPhaseChanged method", e);
            }
        }
    }

    @JavascriptInterface
    public void fireKickedWithReason(Object args) {
        if (this.listener != null) {
            try {
                this.listener.onKickedWithReason(String.valueOf(args));
            }
            catch (AssertionError a) {
                throw a;
            }
            catch (Throwable e) {
                Logger.error("An exception occurred while invoke onKickedWithReason method", e);
            }
        }
    }

    @JavascriptInterface
    public void fireDisconnectWithError(Object args) {
        if (this.listener != null) {
            try {
                this.listener.onDisconnectWithError(new Exception(String.valueOf(args)));
            }
            catch (AssertionError a) {
                throw a;
            }
            catch (Throwable e) {
                Logger.error("An exception occurred while invoke onDisconnectWithError method", e);
            }
        }
    }

    @JavascriptInterface
    public void fireRoomStateChanged(Object args) {
        this.room.getSyncRoomState().syncDisplayerState(String.valueOf(args));
    }

    @JavascriptInterface
    public void fireBeingAbleToCommitChange(Object args) {
        if (this.listener != null) {
            try {
                this.listener.onBeingAbleToCommitChange(Boolean.valueOf(String.valueOf(args)));
            }
            catch (AssertionError a) {
                throw a;
            }
            catch (Throwable e) {
                Logger.error("An exception occurred while invoke onBeingAbleToCommitChange method", e);
            }
        }
    }

    @JavascriptInterface
    public void fireCatchErrorWhenAppendFrame(Object args) {
        FrameError frameError = (FrameError)gson.fromJson(String.valueOf(args), FrameError.class);
        if (this.listener != null) {
            try {
                this.listener.onCatchErrorWhenAppendFrame(frameError.getUserId(), new Exception(frameError.getError()));
            }
            catch (AssertionError a) {
                throw a;
            }
            catch (Throwable e) {
                Logger.error("An exception occurred while invoke onCatchErrorWhenAppendFrame method", e);
            }
        }
    }
}

