/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.support.annotation.ColorInt;
import android.util.Base64;
import com.google.gson.Gson;
import com.herewhite.sdk.WhiteBroadView;
import com.herewhite.sdk.WhiteSdk;
import com.herewhite.sdk.domain.CameraConfig;
import com.herewhite.sdk.domain.Promise;
import com.herewhite.sdk.domain.RectangleConfig;
import com.herewhite.sdk.domain.SDKError;
import wendu.dsbridge.OnReturnValue;

public class Displayer {
    @ColorInt
    private int backgroudColor = -1;
    protected final WhiteBroadView bridge;
    protected String uuid;
    protected final Context context;
    protected WhiteSdk sdk;
    protected static final Gson gson = new Gson();

    public Displayer(String uuid, WhiteBroadView bridge, Context context, WhiteSdk sdk) {
        this.uuid = uuid;
        this.bridge = bridge;
        this.context = context;
        this.sdk = sdk;
    }

    public void setBackgroudColor(int intColor) {
        if ((intColor & 0xFF000000) != -16777216) {
            throw new AssertionError((Object)"alpha is not support to change");
        }
        this.bridge.callHandler("displayer.background", new Object[]{Displayer.toHexString(intColor)});
        this.backgroudColor = intColor;
    }

    public int getBackgroudColor() {
        return this.backgroudColor;
    }

    private static final String toHexString(int intColor) {
        return String.format("#%06X", 0xFFFFFF & intColor);
    }

    public void getScenePreviewImage(String scenePath, final Promise<Bitmap> promise) {
        this.bridge.callHandler("displayerAsync.scenePreview", new Object[]{scenePath}, new OnReturnValue<String>(){

            public void onValue(String retValue) {
                Bitmap bitmap = null;
                try {
                    bitmap = Displayer.this.transformBase64toBitmap(retValue);
                }
                catch (Exception e) {
                    promise.catchEx(new SDKError(e.getMessage()));
                }
                if (bitmap != null) {
                    promise.then(bitmap);
                }
            }
        });
    }

    public void getSceneSnapshotImage(String scenePath, final Promise<Bitmap> promise) {
        this.bridge.callHandler("displayerAsync.sceneSnapshot", new Object[]{scenePath}, new OnReturnValue<String>(){

            public void onValue(String retValue) {
                Bitmap bitmap = null;
                try {
                    bitmap = Displayer.this.transformBase64toBitmap(retValue);
                }
                catch (Exception e) {
                    promise.catchEx(new SDKError(e.getMessage()));
                }
                if (bitmap != null) {
                    promise.then(bitmap);
                }
            }
        });
    }

    private Bitmap transformBase64toBitmap(String base64String) {
        String pureBase64Encoded = base64String.substring(base64String.indexOf(",") + 1);
        byte[] decodedBytes = Base64.decode((String)pureBase64Encoded, (int)0);
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inDensity = this.context.getResources().getDisplayMetrics().densityDpi;
        return BitmapFactory.decodeByteArray((byte[])decodedBytes, (int)0, (int)decodedBytes.length, (BitmapFactory.Options)opts);
    }

    public void moveCamera(CameraConfig camera) {
        this.bridge.callHandler("displayer.moveCamera", new Object[]{camera});
    }

    public void moveCameraToContainer(RectangleConfig rectange) {
        this.bridge.callHandler("displayer.moveCameraToContain", new Object[]{rectange});
    }
}

