/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk.domain;

import com.herewhite.sdk.domain.AnimationMode;
import com.herewhite.sdk.domain.WhiteObject;

public class RectangleConfig
extends WhiteObject {
    private Double originX;
    private Double originY;
    private Double width;
    private Double height;
    private AnimationMode animationMode;

    public RectangleConfig(Double width, Double height, AnimationMode mode) {
        this.width = width;
        this.height = height;
        this.originX = -width.doubleValue() / 2.0;
        this.originY = -height.doubleValue() / 2.0;
        this.animationMode = mode;
    }

    public RectangleConfig(Double width, Double height) {
        this(width, height, AnimationMode.Continuous);
    }

    public RectangleConfig(Double originX, Double originY, Double width, Double height) {
        this(originX, originY, width, height, AnimationMode.Continuous);
    }

    public RectangleConfig(Double originX, Double originY, Double width, Double height, AnimationMode mode) {
        this.originX = originX;
        this.originY = originY;
        this.width = width;
        this.height = height;
        this.animationMode = mode;
    }

    public Double getOriginX() {
        return this.originX;
    }

    public void setOriginX(Double originX) {
        this.originX = originX;
    }

    public Double getOriginY() {
        return this.originY;
    }

    public void setOriginY(Double originY) {
        this.originY = originY;
    }

    public Double getWidth() {
        return this.width;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    public Double getHeight() {
        return this.height;
    }

    public void setHeight(Double height) {
        this.height = height;
    }

    public AnimationMode getAnimationMode() {
        return this.animationMode;
    }

    public void setAnimationMode(AnimationMode animationMode) {
        this.animationMode = animationMode;
    }
}

