/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.support.annotation.ColorInt;
import android.util.Base64;
import com.google.gson.Gson;
import com.herewhite.sdk.WhiteSdk;
import com.herewhite.sdk.WhiteboardView;
import com.herewhite.sdk.domain.CameraBound;
import com.herewhite.sdk.domain.CameraConfig;
import com.herewhite.sdk.domain.Promise;
import com.herewhite.sdk.domain.RectangleConfig;
import com.herewhite.sdk.domain.SDKError;
import wendu.dsbridge.OnReturnValue;

public class Displayer {
    @ColorInt
    private int backgroundColor = -1;
    protected final WhiteboardView bridge;
    protected String uuid;
    protected final Context context;
    protected WhiteSdk sdk;
    protected static final Gson gson = new Gson();

    public Displayer(String uuid, WhiteboardView bridge, Context context, WhiteSdk sdk) {
        this.uuid = uuid;
        this.bridge = bridge;
        this.context = context;
        this.sdk = sdk;
    }

    public void setCameraBound(CameraBound bound) {
        this.bridge.callHandler("displayer.setCameraBound", new Object[]{bound});
    }

    @Deprecated
    public void setBackgroundColor(@ColorInt int intColor) {
        Object[] rgba = Displayer.hexSplit(intColor);
        this.bridge.callHandler("displayer.setBackgroundColor", rgba);
        this.backgroundColor = intColor;
    }

    public static Float[] hexSplit(@ColorInt int color) {
        Float r = Float.valueOf(color >> 16 & 0xFF);
        Float g = Float.valueOf(color >> 8 & 0xFF);
        Float b = Float.valueOf(color & 0xFF);
        Float a = Float.valueOf((float)(color >> 24 & 0xFF) / 255.0f);
        return new Float[]{r, g, b, a};
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public void getScenePreviewImage(String scenePath, final Promise<Bitmap> promise) {
        this.bridge.callHandler("displayerAsync.scenePreview", new Object[]{scenePath}, new OnReturnValue<String>(){

            public void onValue(String retValue) {
                Bitmap bitmap = null;
                try {
                    bitmap = Displayer.this.transformBase64toBitmap(retValue);
                }
                catch (Exception e) {
                    promise.catchEx(new SDKError(e.getMessage()));
                }
                if (bitmap != null) {
                    promise.then(bitmap);
                }
            }
        });
    }

    public void getSceneSnapshotImage(String scenePath, final Promise<Bitmap> promise) {
        this.bridge.callHandler("displayerAsync.sceneSnapshot", new Object[]{scenePath}, new OnReturnValue<String>(){

            public void onValue(String retValue) {
                Bitmap bitmap = null;
                try {
                    bitmap = Displayer.this.transformBase64toBitmap(retValue);
                }
                catch (Exception e) {
                    promise.catchEx(new SDKError(e.getMessage()));
                }
                if (bitmap != null) {
                    promise.then(bitmap);
                }
            }
        });
    }

    private Bitmap transformBase64toBitmap(String base64String) {
        String pureBase64Encoded = base64String.substring(base64String.indexOf(",") + 1);
        byte[] decodedBytes = Base64.decode((String)pureBase64Encoded, (int)0);
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inDensity = this.context.getResources().getDisplayMetrics().densityDpi;
        return BitmapFactory.decodeByteArray((byte[])decodedBytes, (int)0, (int)decodedBytes.length, (BitmapFactory.Options)opts);
    }

    public void moveCamera(CameraConfig camera) {
        this.bridge.callHandler("displayer.moveCamera", new Object[]{camera});
    }

    public void moveCameraToContainer(RectangleConfig rectangle) {
        this.bridge.callHandler("displayer.moveCameraToContain", new Object[]{rectangle});
    }
}

