/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk;

import android.content.Context;
import android.webkit.JavascriptInterface;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.herewhite.sdk.Logger;
import com.herewhite.sdk.Player;
import com.herewhite.sdk.PlayerCallbacksImplement;
import com.herewhite.sdk.PlayerEventListener;
import com.herewhite.sdk.Room;
import com.herewhite.sdk.RoomCallbacks;
import com.herewhite.sdk.RoomCallbacksImplement;
import com.herewhite.sdk.RoomParams;
import com.herewhite.sdk.WhiteBroadView;
import com.herewhite.sdk.WhiteSdkConfiguration;
import com.herewhite.sdk.domain.PlayerConfiguration;
import com.herewhite.sdk.domain.Promise;
import com.herewhite.sdk.domain.SDKError;
import com.herewhite.sdk.domain.UrlInterrupter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import wendu.dsbridge.OnReturnValue;

public class WhiteSdk {
    private static final Gson gson = new Gson();
    private final WhiteBroadView bridge;
    private final Context context;
    private final RoomCallbacksImplement roomCallbacksImplement;
    private final PlayerCallbacksImplement playerCallbacksImplement;
    private UrlInterrupter urlInterrupter;
    private final ConcurrentHashMap<String, Room> roomConcurrentHashMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Player> playerConcurrentHashMap = new ConcurrentHashMap();

    public static String Version() {
        return "2.3.0";
    }

    public WhiteSdk(WhiteBroadView bridge, Context context, WhiteSdkConfiguration whiteSdkConfiguration) {
        this(bridge, context, whiteSdkConfiguration, null);
    }

    public WhiteSdk(WhiteBroadView bridge, Context context, WhiteSdkConfiguration whiteSdkConfiguration, UrlInterrupter urlInterrupter) {
        this.bridge = bridge;
        this.context = context;
        this.urlInterrupter = urlInterrupter;
        this.roomCallbacksImplement = new RoomCallbacksImplement();
        this.playerCallbacksImplement = new PlayerCallbacksImplement();
        bridge.addJavascriptObject(this, "sdk");
        bridge.addJavascriptObject(this.roomCallbacksImplement, "room");
        bridge.addJavascriptObject(this.playerCallbacksImplement, "player");
        bridge.callHandler("sdk.newWhiteSdk", new Object[]{whiteSdkConfiguration});
    }

    public void joinRoom(RoomParams roomParams, Promise<Room> roomPromise) {
        this.joinRoom(roomParams, null, roomPromise);
    }

    public void joinRoom(final RoomParams roomParams, RoomCallbacks roomCallbacks, final Promise<Room> roomPromise) {
        try {
            if (roomCallbacks != null) {
                this.roomCallbacksImplement.setListener(roomCallbacks);
            }
            this.bridge.callHandler("sdk.joinRoom", new Object[]{roomParams.getUuid(), roomParams.getRoomToken(), roomParams.getUserPayload() != null ? roomParams.getUserPayload() : roomParams.getMemberInfo()}, new OnReturnValue<String>(){

                public void onValue(String roomString) {
                    JsonObject jsonObject = (JsonObject)gson.fromJson(roomString, JsonObject.class);
                    if (jsonObject.has("__error")) {
                        String msg = "Unknow exception";
                        String jsStack = "Unknow stack";
                        if (jsonObject.getAsJsonObject("__error").has("message")) {
                            msg = jsonObject.getAsJsonObject("__error").get("message").getAsString();
                        }
                        if (jsonObject.getAsJsonObject("__error").has("jsStack")) {
                            jsStack = jsonObject.getAsJsonObject("__error").get("jsStack").getAsString();
                        }
                        try {
                            roomPromise.catchEx(new SDKError(msg, jsStack));
                        }
                        catch (AssertionError a) {
                            throw a;
                        }
                        catch (Throwable e) {
                            Logger.error("An exception occurred while catch joinRoom method exception", e);
                        }
                    } else {
                        Room room = new Room(roomParams.getUuid(), WhiteSdk.this.bridge, WhiteSdk.this.context, WhiteSdk.this);
                        WhiteSdk.this.roomConcurrentHashMap.put(roomParams.getUuid(), room);
                        WhiteSdk.this.roomCallbacksImplement.setRoom(room);
                        try {
                            roomPromise.then(room);
                        }
                        catch (AssertionError a) {
                            throw a;
                        }
                        catch (Throwable e) {
                            Logger.error("An exception occurred while resolve joinRoom method promise", e);
                        }
                    }
                }
            });
        }
        catch (AssertionError a) {
            throw a;
        }
        catch (Exception e) {
            roomPromise.catchEx(new SDKError(e.getMessage()));
        }
    }

    public void releaseRoom(String uuid) {
        this.roomConcurrentHashMap.remove(uuid);
    }

    public void releasePlayer(String uuid) {
        this.playerConcurrentHashMap.remove(uuid);
    }

    public void createPlayer(PlayerConfiguration playerConfiguration, Promise<Player> playerPromise) {
        this.createPlayer(playerConfiguration, null, playerPromise);
    }

    public void createPlayer(final PlayerConfiguration playerConfiguration, PlayerEventListener playerEventListener, final Promise<Player> playerPromise) {
        try {
            if (playerEventListener != null) {
                this.playerCallbacksImplement.setListener(playerEventListener);
            }
            this.bridge.callHandler("sdk.replayRoom", new Object[]{playerConfiguration}, new OnReturnValue<String>(){

                public void onValue(String roomString) {
                    JsonObject jsonObject = (JsonObject)gson.fromJson(roomString, JsonObject.class);
                    if (jsonObject.has("__error")) {
                        String msg = "Unknow exception";
                        String jsStack = "Unknow stack";
                        if (jsonObject.getAsJsonObject("__error").has("message")) {
                            msg = jsonObject.getAsJsonObject("__error").get("message").getAsString();
                        }
                        if (jsonObject.getAsJsonObject("__error").has("jsStack")) {
                            jsStack = jsonObject.getAsJsonObject("__error").get("jsStack").getAsString();
                        }
                        try {
                            playerPromise.catchEx(new SDKError(msg, jsStack));
                        }
                        catch (AssertionError a) {
                            throw a;
                        }
                        catch (Throwable e) {
                            Logger.error("An exception occurred while catch createPlayer method exception", e);
                        }
                    } else {
                        Player player = new Player(playerConfiguration.getRoom(), WhiteSdk.this.bridge, WhiteSdk.this.context, WhiteSdk.this);
                        WhiteSdk.this.playerCallbacksImplement.setPlayer(player);
                        WhiteSdk.this.playerConcurrentHashMap.put(playerConfiguration.getRoom(), player);
                        try {
                            playerPromise.then(player);
                        }
                        catch (AssertionError a) {
                            throw a;
                        }
                        catch (Throwable e) {
                            Logger.error("An exception occurred while resolve joinRoom method promise", e);
                        }
                    }
                }
            });
        }
        catch (AssertionError a) {
            throw a;
        }
        catch (Exception e) {
            playerPromise.catchEx(new SDKError(e.getMessage()));
        }
    }

    @JavascriptInterface
    public String urlInterrupter(Object args) {
        if (this.urlInterrupter == null) {
            return String.valueOf(args);
        }
        return this.urlInterrupter.urlInterrupter(String.valueOf(args));
    }

    @JavascriptInterface
    public void throwError(Object args) {
        Logger.info("WhiteSDK JS error: " + gson.fromJson(String.valueOf(args), Map.class));
    }

    @JavascriptInterface
    public void logger(Object args) {
        Logger.info("WhiteSDK logger: " + gson.fromJson(String.valueOf(args), Map.class));
    }
}

