/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class SyncDisplayerState<T> {
    private static final Gson gson = new Gson();
    private static final JsonParser parser = new JsonParser();
    private final Class<T> clazz;
    private final boolean disableCallbackWhilePutting;
    private JsonObject stateJSON;
    private Listener<T> listener;

    public SyncDisplayerState(Class<T> clazz, boolean disableCallbackWhilePutting) {
        this.clazz = clazz;
        this.disableCallbackWhilePutting = disableCallbackWhilePutting;
    }

    public T getDisplayerState() {
        return (T)gson.fromJson((JsonElement)this.stateJSON, this.clazz);
    }

    public void setListener(Listener<T> listener) {
        this.listener = listener;
    }

    public void syncDisplayerState(String stateJSON) {
        JsonObject modifyStateJSON = this.compareAndModifyStateJSON(parser.parse(stateJSON).getAsJsonObject());
        if (this.listener != null && modifyStateJSON != null) {
            Object modifyState = gson.fromJson((JsonElement)modifyStateJSON, this.clazz);
            this.listener.onDisplayerStateChanged(modifyState);
        }
    }

    void putProperty(String key, Object value) {
        JsonElement newValue;
        JsonElement originalValue = this.stateJSON.get(key);
        if (originalValue != null && !SyncDisplayerState.compareJson(originalValue, newValue = SyncDisplayerState.assignObject(this.stateJSON.get(key), gson.toJsonTree(value)))) {
            JsonObject newStateJSON = new JsonObject();
            for (String otherKey : this.stateJSON.keySet()) {
                if (otherKey.equals(key)) {
                    newStateJSON.add(otherKey, newValue);
                    continue;
                }
                newStateJSON.add(otherKey, this.stateJSON.get(otherKey));
            }
            this.stateJSON = newStateJSON;
            if (!this.disableCallbackWhilePutting) {
                JsonObject modifyStateJSON = new JsonObject();
                modifyStateJSON.add(key, newValue);
                Object modifyState = gson.fromJson((JsonElement)modifyStateJSON, this.clazz);
                this.listener.onDisplayerStateChanged(modifyState);
            }
        }
    }

    private JsonObject compareAndModifyStateJSON(JsonObject modifyStateJSON) {
        if (this.stateJSON == null) {
            this.stateJSON = modifyStateJSON;
            return null;
        }
        JsonObject jsonObject = new JsonObject();
        JsonObject checkedModifyStateJSON = null;
        String[] strs = this.stateJSON.keySet().toArray(new String[0]);
        HashSet<String> keySet = new HashSet<String>(Arrays.asList(strs));
        keySet.addAll(modifyStateJSON.keySet());
        for (String key : keySet) {
            JsonElement originalValue = this.stateJSON.get(key);
            JsonElement newValue = modifyStateJSON.get(key);
            if (newValue != null) {
                if (!SyncDisplayerState.compareJson(originalValue, newValue)) {
                    if (checkedModifyStateJSON == null) {
                        checkedModifyStateJSON = new JsonObject();
                    }
                    checkedModifyStateJSON.add(key, newValue);
                }
                jsonObject.add(key, newValue);
                continue;
            }
            if (originalValue == null) continue;
            jsonObject.add(key, originalValue);
        }
        this.stateJSON = jsonObject;
        return checkedModifyStateJSON;
    }

    private static JsonElement assignObject(JsonElement value1, JsonElement value2) {
        if (!value1.isJsonObject() || !value2.isJsonObject()) {
            return value2;
        }
        JsonObject object1 = (JsonObject)value1;
        JsonObject object2 = (JsonObject)value2;
        JsonObject newObject = new JsonObject();
        for (String key : object1.keySet()) {
            if (object2.has(key)) {
                newObject.add(key, object2.get(key));
                continue;
            }
            newObject.add(key, object1.get(key));
        }
        for (String key : object2.keySet()) {
            if (newObject.has(key)) continue;
            newObject.add(key, object2.get(key));
        }
        return newObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean compareJson(JsonElement json1, JsonElement json2) {
        boolean isEqual = true;
        if (json1 == null || json2 == null) return json1 == null && json2 == null;
        if (json1.isJsonObject() && json2.isJsonObject()) {
            Set ens1 = ((JsonObject)json1).entrySet();
            Set ens2 = ((JsonObject)json2).entrySet();
            JsonObject json2obj = (JsonObject)json2;
            if (ens1 == null || ens2 == null || ens2.size() != ens1.size()) return false;
            for (Map.Entry en : ens1) {
                isEqual = isEqual && SyncDisplayerState.compareJson((JsonElement)en.getValue(), json2obj.get((String)en.getKey()));
            }
            return isEqual;
        } else if (json1.isJsonArray() && json2.isJsonArray()) {
            JsonArray jarr1 = json1.getAsJsonArray();
            JsonArray jarr2 = json2.getAsJsonArray();
            if (jarr1.size() != jarr2.size()) {
                return false;
            }
            int i = 0;
            for (JsonElement je : jarr1) {
                isEqual = isEqual && SyncDisplayerState.compareJson(je, jarr2.get(i));
                ++i;
            }
            return isEqual;
        } else {
            if (json1.isJsonNull() && json2.isJsonNull()) {
                return true;
            }
            if (!json1.isJsonPrimitive() || !json2.isJsonPrimitive()) return false;
            return json1.equals(json2);
        }
    }

    public static interface Listener<T> {
        public void onDisplayerStateChanged(T var1);
    }
}

