/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk;

import android.webkit.JavascriptInterface;
import androidx.annotation.Nullable;
import com.herewhite.sdk.CommonCallback;
import com.herewhite.sdk.CommonCallbacks;
import com.herewhite.sdk.Utils;
import com.herewhite.sdk.domain.SDKError;
import com.herewhite.sdk.domain.UrlInterrupter;
import com.herewhite.sdk.internal.Logger;
import java.util.Map;
import org.json.JSONObject;

class SdkJsInterfaceImpl {
    @Nullable
    private CommonCallback commonCallback;
    @Nullable
    private UrlInterrupter urlInterrupter;

    public SdkJsInterfaceImpl(CommonCallback commonCallback) {
        this.commonCallback = commonCallback;
    }

    public void setCommonCallbacks(@Nullable CommonCallbacks commonCallbacks) {
        this.commonCallback = commonCallbacks;
    }

    public void setUrlInterrupter(@Nullable UrlInterrupter urlInterrupter) {
        this.urlInterrupter = urlInterrupter;
    }

    @Nullable
    public UrlInterrupter getUrlInterrupter() {
        return this.urlInterrupter;
    }

    @JavascriptInterface
    public String urlInterrupter(Object args) {
        if (this.commonCallback != null) {
            return this.commonCallback.urlInterrupter(String.valueOf(args));
        }
        if (this.urlInterrupter == null) {
            return String.valueOf(args);
        }
        return this.urlInterrupter.urlInterrupter(String.valueOf(args));
    }

    @JavascriptInterface
    public void throwError(Object args) {
        Logger.info("WhiteSDK JS error: " + Utils.fromJson(String.valueOf(args), Map.class));
        if (this.commonCallback != null) {
            this.commonCallback.throwError(args);
        }
    }

    @JavascriptInterface
    public void logger(Object args) {
        Logger.info("WhiteSDK logger: " + Utils.fromJson(String.valueOf(args), Map.class));
    }

    @JavascriptInterface
    public void postMessage(Object args) {
        if (this.commonCallback != null) {
            try {
                JSONObject object = new JSONObject((String)args);
                this.commonCallback.onMessage(object);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @JavascriptInterface
    public void onPPTMediaPlay(Object args) {
        if (this.commonCallback != null) {
            this.commonCallback.onPPTMediaPlay();
        }
    }

    @JavascriptInterface
    public void onPPTMediaPause(Object args) {
        if (this.commonCallback != null) {
            this.commonCallback.onPPTMediaPause();
        }
    }

    @JavascriptInterface
    public void setupFail(Object object) {
        if (this.commonCallback != null && object instanceof JSONObject) {
            SDKError sdkError = SDKError.parseError((JSONObject)object);
            this.commonCallback.sdkSetupFail(sdkError);
        }
    }
}

