/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk;

import android.webkit.JavascriptInterface;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.herewhite.sdk.PlayerDelegate;
import com.herewhite.sdk.domain.EventEntry;
import com.herewhite.sdk.domain.PlayerPhase;
import com.herewhite.sdk.domain.SDKError;
import com.herewhite.sdk.internal.JsCallWrapper;

class PlayerJsInterfaceImpl {
    private static final Gson gson = new Gson();
    private PlayerDelegate player;

    PlayerJsInterfaceImpl() {
    }

    void setPlayer(PlayerDelegate player) {
        this.player = player;
    }

    @JavascriptInterface
    public void fireMagixEvent(Object args) {
        if (this.player != null) {
            new JsCallWrapper(() -> this.player.fireMagixEvent((EventEntry)gson.fromJson(String.valueOf(args), EventEntry.class)), "An exception occurred while sending the event").run();
        }
    }

    @JavascriptInterface
    public void fireHighFrequencyEvent(Object args) {
        if (this.player != null) {
            new JsCallWrapper(() -> {
                EventEntry[] events = (EventEntry[])gson.fromJson(String.valueOf(args), EventEntry[].class);
                this.player.fireHighFrequencyEvent(events);
            }, "An exception occurred while sending the event").run();
        }
    }

    @JavascriptInterface
    public void onPhaseChanged(Object args) {
        if (this.player != null) {
            new JsCallWrapper(() -> {
                PlayerPhase phase = (PlayerPhase)((Object)((Object)gson.fromJson(String.valueOf(args), PlayerPhase.class)));
                this.player.setPlayerPhase(phase);
            }, "An exception occurred while invoke onPhaseChanged method").run();
        }
    }

    @JavascriptInterface
    public void onLoadFirstFrame(Object args) {
        if (this.player != null) {
            this.player.onLoadFirstFrame();
        }
    }

    @JavascriptInterface
    public void onSliceChanged(Object args) {
        if (this.player != null) {
            new JsCallWrapper(() -> this.player.onSliceChanged(String.valueOf(args)), "An exception occurred while invoke onSliceChanged method").run();
        }
    }

    @JavascriptInterface
    public void onPlayerStateChanged(Object args) {
        if (this.player != null) {
            this.player.syncDisplayerState(String.valueOf(args));
        }
    }

    @JavascriptInterface
    public void onStoppedWithError(Object args) {
        if (this.player != null) {
            new JsCallWrapper(() -> this.player.onStoppedWithError(this.resolverSDKError(args)), "An exception occurred while invoke onStoppedWithError method").run();
        }
    }

    private SDKError resolverSDKError(Object args) {
        JsonObject jsonObject = (JsonObject)gson.fromJson(String.valueOf(args), JsonObject.class);
        String message = "";
        if (jsonObject.get("message") != null) {
            message = jsonObject.get("message").getAsString();
        }
        String jsStack = "";
        if (jsonObject.get("jsStack") != null) {
            jsStack = jsonObject.get("jsStack").getAsString();
        }
        SDKError sdkError = new SDKError(message, jsStack);
        return sdkError;
    }

    @JavascriptInterface
    public void onScheduleTimeChanged(Object args) {
        if (this.player != null) {
            new JsCallWrapper(() -> {
                long scheduleTime = 0L;
                String valueString = String.valueOf(args);
                scheduleTime = valueString.contains(".") ? Math.round(Double.parseDouble(String.valueOf(args))) : Long.parseLong(String.valueOf(args));
                this.player.setScheduleTime(scheduleTime);
            }, "An exception occurred while invoke onScheduleTimeChanged method").run();
        }
    }

    @JavascriptInterface
    public void onCatchErrorWhenAppendFrame(Object args) {
        if (this.player != null) {
            new JsCallWrapper(() -> this.player.onCatchErrorWhenAppendFrame(this.resolverSDKError(args)), "An exception occurred while invoke onCatchErrorWhenAppendFrame method").run();
        }
    }

    @JavascriptInterface
    public void onCatchErrorWhenRender(Object args) {
        if (this.player != null) {
            new JsCallWrapper(() -> this.player.onCatchErrorWhenRender(this.resolverSDKError(args)), "An exception occurred while invoke onCatchErrorWhenRender method").run();
        }
    }
}

