/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk;

import android.webkit.JavascriptInterface;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.herewhite.sdk.Logger;
import com.herewhite.sdk.PlayerEventListener;
import com.herewhite.sdk.domain.FrameError;
import com.herewhite.sdk.domain.PlayerPhase;
import com.herewhite.sdk.domain.PlayerState;
import com.herewhite.sdk.domain.SDKError;
import com.herewhite.sdk.domain.UpdateCursor;

public class PlayerCallbacksImplement {
    private static final Gson gson = new Gson();
    private PlayerEventListener listener;

    public PlayerEventListener getListener() {
        return this.listener;
    }

    public void setListener(PlayerEventListener listener) {
        this.listener = listener;
    }

    @JavascriptInterface
    public void onPhaseChanged(Object args) {
        if (this.listener != null) {
            try {
                this.listener.onPhaseChanged(PlayerPhase.valueOf(String.valueOf(args)));
            }
            catch (Throwable e) {
                Logger.error("An exception occurred while invoke onPhaseChanged method", e);
            }
        }
    }

    @JavascriptInterface
    public void onLoadFirstFrame(Object args) {
        if (this.listener != null) {
            try {
                this.listener.onLoadFirstFrame();
            }
            catch (Throwable e) {
                Logger.error("An exception occurred while invoke onLoadFirstFrame method", e);
            }
        }
    }

    @JavascriptInterface
    public void onSliceChanged(Object args) {
        if (this.listener != null) {
            try {
                this.listener.onSliceChanged(String.valueOf(args));
            }
            catch (Throwable e) {
                Logger.error("An exception occurred while invoke onSliceChanged method", e);
            }
        }
    }

    @JavascriptInterface
    public void onPlayerStateChanged(Object args) {
        if (this.listener != null) {
            try {
                PlayerState playerState = (PlayerState)gson.fromJson(String.valueOf(args), PlayerState.class);
                this.listener.onPlayerStateChanged(playerState);
            }
            catch (Throwable e) {
                Logger.error("An exception occurred while invoke onPlayerStateChanged method", e);
            }
        }
    }

    @JavascriptInterface
    public void onStoppedWithError(Object args) {
        if (this.listener != null) {
            try {
                this.listener.onStoppedWithError(this.resolverSDKError(args));
            }
            catch (Throwable e) {
                Logger.error("An exception occurred while invoke onStoppedWithError method", e);
            }
        }
    }

    private SDKError resolverSDKError(Object args) {
        JsonObject jsonObject = (JsonObject)gson.fromJson(String.valueOf(args), JsonObject.class);
        String message = jsonObject.get("message").getAsString();
        String jsStack = jsonObject.get("jsStack").getAsString();
        SDKError sdkError = new SDKError(message, jsStack);
        return sdkError;
    }

    @JavascriptInterface
    public void onScheduleTimeChanged(Object args) {
        if (this.listener != null) {
            try {
                this.listener.onScheduleTimeChanged(Long.parseLong(String.valueOf(args)));
            }
            catch (Throwable e) {
                Logger.error("An exception occurred while invoke onScheduleTimeChanged method", e);
            }
        }
    }

    @JavascriptInterface
    public void onCatchErrorWhenAppendFrame(Object args) {
        if (this.listener != null) {
            try {
                this.listener.onCatchErrorWhenAppendFrame(this.resolverSDKError(args));
            }
            catch (Throwable e) {
                Logger.error("An exception occurred while invoke onCatchErrorWhenAppendFrame method", e);
            }
        }
    }

    @JavascriptInterface
    public void onCatchErrorWhenRender(Object args) {
        if (this.listener != null) {
            try {
                FrameError frameError = (FrameError)gson.fromJson(String.valueOf(args), FrameError.class);
                this.listener.onCatchErrorWhenRender(this.resolverSDKError(args));
            }
            catch (Throwable e) {
                Logger.error("An exception occurred while invoke onCatchErrorWhenRender method", e);
            }
        }
    }

    @JavascriptInterface
    public void onCursorViewsUpdate(Object args) {
        if (this.listener != null) {
            try {
                UpdateCursor updateCursor = (UpdateCursor)gson.fromJson(String.valueOf(args), UpdateCursor.class);
                this.listener.onCursorViewsUpdate(updateCursor);
            }
            catch (Throwable e) {
                Logger.error("An exception occurred while invoke onCursorViewsUpdate method", e);
            }
        }
    }
}

