/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk;

import android.content.Context;
import android.util.Log;
import android.webkit.JavascriptInterface;
import com.google.gson.Gson;
import com.herewhite.sdk.Room;
import com.herewhite.sdk.RoomCallbacks;
import com.herewhite.sdk.RoomParams;
import com.herewhite.sdk.WhiteBroadView;
import com.herewhite.sdk.WhiteSdkConfiguration;
import com.herewhite.sdk.domain.FrameError;
import com.herewhite.sdk.domain.Promise;
import com.herewhite.sdk.domain.RoomPhase;
import com.herewhite.sdk.domain.RoomState;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import wendu.dsbridge.OnReturnValue;

public class WhiteSdk {
    private static final Gson gson = new Gson();
    private final WhiteBroadView bridge;
    private final Context context;
    private final List<RoomCallbacks> listeners = new ArrayList<RoomCallbacks>();

    public WhiteSdk(WhiteBroadView bridge, Context context, WhiteSdkConfiguration whiteSdkConfiguration) {
        this.bridge = bridge;
        this.context = context;
        bridge.addJavascriptObject(this, "sdk");
        bridge.callHandler("sdk.newWhiteSdk", new Object[]{whiteSdkConfiguration.getDeviceType().name(), whiteSdkConfiguration.getZoomMaxScale(), whiteSdkConfiguration.getZoomMinScale()});
    }

    public void joinRoom(RoomParams roomParams, final Promise<Room> roomPromise) {
        try {
            this.bridge.callHandler("sdk.joinRoom", new Object[]{roomParams.getUuid(), roomParams.getRoomToken()}, (OnReturnValue)new OnReturnValue<String>(){

                public void onValue(String retValue) {
                    Log.d((String)"jsbridge", (String)("call succeed,return value is " + retValue));
                    roomPromise.then(new Room(WhiteSdk.this.bridge, WhiteSdk.this.context));
                }
            });
        }
        catch (Exception e) {
            roomPromise.catchEx(e);
        }
    }

    public void addRoomCallbacks(RoomCallbacks callback) {
        this.listeners.add(callback);
    }

    @JavascriptInterface
    public void firePhaseChanged(Object args) throws JSONException {
        for (RoomCallbacks roomCallbacks : this.listeners) {
            roomCallbacks.onPhaseChanged(RoomPhase.valueOf(String.valueOf(args)));
        }
    }

    @JavascriptInterface
    public void fireKickedWithReason(Object args) throws JSONException {
        for (RoomCallbacks roomCallbacks : this.listeners) {
            roomCallbacks.onKickedWithReason(String.valueOf(args));
        }
    }

    @JavascriptInterface
    public void fireDisconnectWithError(Object args) throws JSONException {
        for (RoomCallbacks roomCallbacks : this.listeners) {
            roomCallbacks.onDisconnectWithError(new Exception(String.valueOf(args)));
        }
    }

    @JavascriptInterface
    public void fireRoomStateChanged(Object args) throws JSONException {
        RoomState roomState = (RoomState)gson.fromJson(String.valueOf(args), RoomState.class);
        for (RoomCallbacks roomCallbacks : this.listeners) {
            roomCallbacks.onRoomStateChanged(roomState);
        }
    }

    @JavascriptInterface
    public void fireBeingAbleToCommitChange(Object args) throws JSONException {
        for (RoomCallbacks roomCallbacks : this.listeners) {
            roomCallbacks.onBeingAbleToCommitChange(Boolean.valueOf(String.valueOf(args)));
        }
    }

    @JavascriptInterface
    public void fireCatchErrorWhenAppendFrame(Object args) throws JSONException {
        FrameError frameError = (FrameError)gson.fromJson(String.valueOf(args), FrameError.class);
        for (RoomCallbacks roomCallbacks : this.listeners) {
            roomCallbacks.onCatchErrorWhenAppendFrame(frameError.getUserId(), new Exception(frameError.getError()));
        }
    }
}

