/*
 * Decompiled with CFR 0.152.
 */
package com.dueeeke.videoplayer.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.dueeeke.videoplayer.R;
import com.dueeeke.videoplayer.util.WindowUtil;

@SuppressLint(value={"ViewConstructor"})
public class FloatView
extends FrameLayout {
    private WindowManager mWindowManager;
    private WindowManager.LayoutParams mParams;
    private int floatX;
    private int floatY;
    private boolean firstTouch = true;

    public FloatView(@NonNull Context context, int x, int y) {
        super(context);
        this.floatX = x;
        this.floatY = y;
        this.init();
    }

    private void init() {
        this.setBackgroundResource(R.drawable.shape_float_window_background);
        int padding = WindowUtil.dp2px(this.getContext(), 1.0f);
        this.setPadding(padding, padding, padding, padding);
        this.initWindow();
    }

    private void initWindow() {
        int width;
        this.mWindowManager = WindowUtil.getWindowManager(this.getContext().getApplicationContext());
        this.mParams = new WindowManager.LayoutParams();
        this.mParams.type = 2003;
        this.mParams.format = 1;
        this.mParams.flags = 8;
        this.mParams.gravity = 0x800033;
        this.mParams.width = width = WindowUtil.dp2px(this.getContext(), 250.0f);
        this.mParams.height = width * 9 / 16;
        this.mParams.x = this.floatX;
        this.mParams.y = this.floatY;
    }

    public boolean addToWindow() {
        if (this.mWindowManager != null) {
            if (Build.VERSION.SDK_INT >= 19) {
                if (!this.isAttachedToWindow()) {
                    this.mWindowManager.addView((View)this, (ViewGroup.LayoutParams)this.mParams);
                    return true;
                }
                return false;
            }
            try {
                if (this.getParent() == null) {
                    this.mWindowManager.addView((View)this, (ViewGroup.LayoutParams)this.mParams);
                }
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public boolean removeFromWindow() {
        if (this.mWindowManager != null) {
            if (Build.VERSION.SDK_INT >= 19) {
                if (this.isAttachedToWindow()) {
                    this.mWindowManager.removeViewImmediate((View)this);
                    return true;
                }
                return false;
            }
            try {
                if (this.getParent() != null) {
                    this.mWindowManager.removeViewImmediate((View)this);
                }
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return ev.getAction() != 0;
    }

    public boolean onTouchEvent(MotionEvent event) {
        int X = (int)event.getRawX();
        int Y = (int)event.getRawY();
        switch (event.getAction()) {
            case 1: {
                this.firstTouch = true;
                break;
            }
            case 2: {
                if (this.firstTouch) {
                    this.floatX = (int)event.getX();
                    this.floatY = (int)((double)event.getY() + WindowUtil.getStatusBarHeight(this.getContext()));
                    this.firstTouch = false;
                }
                this.mParams.x = X - this.floatX;
                this.mParams.y = Y - this.floatY;
                this.mWindowManager.updateViewLayout((View)this, (ViewGroup.LayoutParams)this.mParams);
            }
        }
        return super.onTouchEvent(event);
    }
}

