/*
 * Decompiled with CFR 0.152.
 */
package com.dueeeke.videoplayer.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

public class NetworkUtil {
    public static final int NO_NETWORK = 0;
    public static final int NETWORK_CLOSED = 1;
    public static final int NETWORK_ETHERNET = 2;
    public static final int NETWORK_WIFI = 3;
    public static final int NETWORK_MOBILE = 4;
    public static final int NETWORK_UNKNOWN = -1;

    public static int getNetworkType(Context context) {
        ConnectivityManager connectMgr = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
        if (connectMgr == null) {
            return 0;
        }
        NetworkInfo networkInfo = connectMgr.getActiveNetworkInfo();
        if (networkInfo == null) {
            return 0;
        }
        if (!networkInfo.isConnected()) {
            return 1;
        }
        if (networkInfo.getType() == 9) {
            return 2;
        }
        if (networkInfo.getType() == 1) {
            return 3;
        }
        if (networkInfo.getType() == 0) {
            switch (networkInfo.getSubtype()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    return 4;
                }
            }
        }
        return -1;
    }
}

