/*
 * Decompiled with CFR 0.152.
 */
package com.dueeeke.videoplayer.player;

import android.app.Activity;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.dueeeke.videoplayer.R;
import com.dueeeke.videoplayer.controller.BaseVideoController;
import com.dueeeke.videoplayer.player.BaseIjkVideoView;
import com.dueeeke.videoplayer.player.VideoViewManager;
import com.dueeeke.videoplayer.util.Constants;
import com.dueeeke.videoplayer.util.NetworkUtil;
import com.dueeeke.videoplayer.util.WindowUtil;
import com.dueeeke.videoplayer.widget.ResizeSurfaceView;
import com.dueeeke.videoplayer.widget.ResizeTextureView;
import com.dueeeke.videoplayer.widget.StatusView;

public class IjkVideoView
extends BaseIjkVideoView {
    protected ResizeSurfaceView mSurfaceView;
    protected ResizeTextureView mTextureView;
    protected SurfaceTexture mSurfaceTexture;
    protected FrameLayout playerContainer;
    protected StatusView statusView;
    protected boolean useSurfaceView;
    protected boolean isFullScreen;
    public static final int SCREEN_SCALE_DEFAULT = 0;
    public static final int SCREEN_SCALE_16_9 = 1;
    public static final int SCREEN_SCALE_4_3 = 2;
    public static final int SCREEN_SCALE_MATCH_PARENT = 3;
    public static final int SCREEN_SCALE_ORIGINAL = 4;
    protected int mCurrentScreenScale = 0;

    public IjkVideoView(@NonNull Context context) {
        this(context, null);
    }

    public IjkVideoView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public IjkVideoView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    protected void initView() {
        Constants.SCREEN_HEIGHT = WindowUtil.getScreenHeight(this.getContext(), false);
        Constants.SCREEN_WIDTH = WindowUtil.getScreenWidth(this.getContext());
        this.playerContainer = new FrameLayout(this.getContext());
        this.playerContainer.setBackgroundColor(-16777216);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        this.addView((View)this.playerContainer, (ViewGroup.LayoutParams)params);
    }

    @Override
    protected void initPlayer() {
        super.initPlayer();
        this.addDisplay();
    }

    protected void addDisplay() {
        if (this.useSurfaceView) {
            this.addSurfaceView();
        } else {
            this.addTextureView();
        }
    }

    @Override
    protected void setPlayState(int playState) {
        if (this.mVideoController != null) {
            this.mVideoController.setPlayState(playState);
        }
    }

    @Override
    protected void setPlayerState(int playerState) {
        if (this.mVideoController != null) {
            this.mVideoController.setPlayerState(playerState);
        }
    }

    @Override
    protected void startPlay() {
        if (this.addToPlayerManager) {
            VideoViewManager.instance().releaseVideoPlayer();
            VideoViewManager.instance().setCurrentVideoPlayer(this);
        }
        super.startPlay();
    }

    private void addSurfaceView() {
        this.playerContainer.removeView((View)this.mSurfaceView);
        this.mSurfaceView = new ResizeSurfaceView(this.getContext());
        SurfaceHolder surfaceHolder = this.mSurfaceView.getHolder();
        surfaceHolder.addCallback(new SurfaceHolder.Callback(){

            public void surfaceCreated(SurfaceHolder holder) {
            }

            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                if (IjkVideoView.this.mMediaPlayer != null) {
                    IjkVideoView.this.mMediaPlayer.setDisplay(holder);
                }
            }

            public void surfaceDestroyed(SurfaceHolder holder) {
            }
        });
        surfaceHolder.setFormat(1);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1, 17);
        this.playerContainer.addView((View)this.mSurfaceView, 0, (ViewGroup.LayoutParams)params);
    }

    private void addTextureView() {
        this.playerContainer.removeView((View)this.mTextureView);
        this.mSurfaceTexture = null;
        this.mTextureView = new ResizeTextureView(this.getContext());
        this.mTextureView.setSurfaceTextureListener(new TextureView.SurfaceTextureListener(){

            public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
                if (IjkVideoView.this.mSurfaceTexture != null) {
                    IjkVideoView.this.mTextureView.setSurfaceTexture(IjkVideoView.this.mSurfaceTexture);
                } else {
                    IjkVideoView.this.mSurfaceTexture = surfaceTexture;
                    IjkVideoView.this.mMediaPlayer.setSurface(new Surface(surfaceTexture));
                }
            }

            public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
            }

            public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
                return IjkVideoView.this.mSurfaceTexture == null;
            }

            public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
            }
        });
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1, 17);
        this.playerContainer.addView((View)this.mTextureView, 0, (ViewGroup.LayoutParams)params);
    }

    @Override
    protected boolean checkNetwork() {
        if (NetworkUtil.getNetworkType(this.getContext()) == 4 && !Constants.IS_PLAY_ON_MOBILE_NETWORK) {
            this.playerContainer.removeView((View)this.statusView);
            if (this.statusView == null) {
                this.statusView = new StatusView(this.getContext());
            }
            this.statusView.setMessage(this.getResources().getString(R.string.wifi_tip));
            this.statusView.setButtonTextAndAction(this.getResources().getString(R.string.continue_play), v -> {
                Constants.IS_PLAY_ON_MOBILE_NETWORK = true;
                this.playerContainer.removeView((View)this.statusView);
                this.initPlayer();
                this.startPrepare();
            });
            this.playerContainer.addView((View)this.statusView);
            return true;
        }
        return false;
    }

    @Override
    public void release() {
        super.release();
        this.playerContainer.removeView((View)this.mTextureView);
        this.playerContainer.removeView((View)this.mSurfaceView);
        this.playerContainer.removeView((View)this.statusView);
        if (this.mSurfaceTexture != null) {
            this.mSurfaceTexture.release();
            this.mSurfaceTexture = null;
        }
    }

    @Override
    public void startFullScreen() {
        if (this.mVideoController == null) {
            return;
        }
        Activity activity = WindowUtil.scanForActivity(this.mVideoController.getContext());
        if (activity == null) {
            return;
        }
        if (this.isFullScreen) {
            return;
        }
        WindowUtil.hideSystemBar(this.getContext());
        this.removeView((View)this.playerContainer);
        ViewGroup contentView = (ViewGroup)activity.findViewById(0x1020002);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        contentView.addView((View)this.playerContainer, (ViewGroup.LayoutParams)params);
        this.orientationEventListener.enable();
        this.isFullScreen = true;
        this.mVideoController.setPlayerState(11);
    }

    @Override
    public void stopFullScreen() {
        if (this.mVideoController == null) {
            return;
        }
        Activity activity = WindowUtil.scanForActivity(this.mVideoController.getContext());
        if (activity == null) {
            return;
        }
        if (!this.isFullScreen) {
            return;
        }
        if (!this.mAutoRotate) {
            this.orientationEventListener.disable();
        }
        WindowUtil.showSystemBar(this.getContext());
        ViewGroup contentView = (ViewGroup)activity.findViewById(0x1020002);
        contentView.removeView((View)this.playerContainer);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        this.addView((View)this.playerContainer, (ViewGroup.LayoutParams)params);
        this.isFullScreen = false;
        if (this.mVideoController != null) {
            this.mVideoController.setPlayerState(10);
        }
    }

    @Override
    public boolean isFullScreen() {
        return this.isFullScreen;
    }

    @Override
    public void onError() {
        super.onError();
        this.playerContainer.removeView((View)this.statusView);
        if (this.statusView == null) {
            this.statusView = new StatusView(this.getContext());
        }
        this.statusView.setMessage(this.getResources().getString(R.string.error_message));
        this.statusView.setButtonTextAndAction(this.getResources().getString(R.string.retry), v -> {
            this.playerContainer.removeView((View)this.statusView);
            this.mMediaPlayer.reset();
            this.startPrepare();
        });
        this.playerContainer.addView((View)this.statusView);
    }

    @Override
    public void onInfo(int what, int extra) {
        super.onInfo(what, extra);
        switch (what) {
            case 10001: {
                if (this.mTextureView == null) break;
                this.mTextureView.setRotation(extra);
            }
        }
    }

    @Override
    public void onVideoSizeChanged(int videoWidth, int videoHeight) {
        if (this.useSurfaceView) {
            this.mSurfaceView.setScreenScale(this.mCurrentScreenScale);
            this.mSurfaceView.setVideoSize(videoWidth, videoHeight);
        } else {
            this.mTextureView.setScreenScale(this.mCurrentScreenScale);
            this.mTextureView.setVideoSize(videoWidth, videoHeight);
        }
    }

    public IjkVideoView setVideoController(@Nullable BaseVideoController mediaController) {
        this.playerContainer.removeView((View)this.mVideoController);
        if (mediaController != null) {
            mediaController.setMediaPlayer(this);
            this.mVideoController = mediaController;
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
            this.playerContainer.addView((View)this.mVideoController, (ViewGroup.LayoutParams)params);
        }
        return this;
    }

    public boolean onBackPressed() {
        return this.mVideoController != null && this.mVideoController.onBackPressed();
    }

    public IjkVideoView setUrl(String url) {
        this.mCurrentUrl = url;
        return this;
    }

    public IjkVideoView skipPositionWhenPlay(String url, int position) {
        this.mCurrentUrl = url;
        this.mCurrentPosition = position;
        return this;
    }

    public IjkVideoView setTitle(String title) {
        if (title != null) {
            this.mCurrentTitle = title;
        }
        return this;
    }

    public IjkVideoView enableCache() {
        this.isCache = true;
        return this;
    }

    public IjkVideoView addToPlayerManager() {
        this.addToPlayerManager = true;
        return this;
    }

    @Override
    public void setScreenScale(int screenScale) {
        this.mCurrentScreenScale = screenScale;
        if (this.mSurfaceView != null) {
            this.mSurfaceView.setScreenScale(screenScale);
        }
        if (this.mTextureView != null) {
            this.mTextureView.setScreenScale(screenScale);
        }
    }

    public IjkVideoView useSurfaceView() {
        this.useSurfaceView = true;
        return this;
    }

    public IjkVideoView useAndroidMediaPlayer() {
        this.useAndroidMediaPlayer = true;
        return this;
    }

    public IjkVideoView autoRotate() {
        this.mAutoRotate = true;
        return this;
    }
}

