/*
 * Decompiled with CFR 0.152.
 */
package com.dueeeke.videoplayer.controller;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import com.dueeeke.videoplayer.R;
import com.dueeeke.videoplayer.controller.BaseVideoController;
import com.dueeeke.videoplayer.util.BatteryReceiver;
import com.dueeeke.videoplayer.util.L;
import com.dueeeke.videoplayer.util.WindowUtil;
import com.dueeeke.videoplayer.widget.MarqueeTextView;

public class StandardVideoController
extends BaseVideoController
implements View.OnClickListener,
SeekBar.OnSeekBarChangeListener {
    protected TextView totalTime;
    protected TextView currTime;
    protected ImageView fullScreenButton;
    protected LinearLayout bottomContainer;
    protected LinearLayout topContainer;
    protected SeekBar videoProgress;
    protected ImageView backButton;
    protected ImageView lock;
    protected MarqueeTextView title;
    private boolean isLive;
    private boolean isDragging;
    private ProgressBar bottomProgress;
    private ImageView playButton;
    private ImageView startPlayButton;
    private ProgressBar loadingProgress;
    private ImageView thumb;
    private LinearLayout completeContainer;
    private TextView sysTime;
    private ImageView batteryLevel;
    private Animation showAnim = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.anim_alpha_in);
    private Animation hideAnim = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.anim_alpha_out);
    private BatteryReceiver mBatteryReceiver;

    public StandardVideoController(@NonNull Context context) {
        this(context, null);
    }

    public StandardVideoController(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public StandardVideoController(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected int getLayoutId() {
        return R.layout.layout_standard_controller;
    }

    @Override
    protected void initView() {
        super.initView();
        this.fullScreenButton = (ImageView)this.controllerView.findViewById(R.id.fullscreen);
        this.fullScreenButton.setOnClickListener((View.OnClickListener)this);
        this.bottomContainer = (LinearLayout)this.controllerView.findViewById(R.id.bottom_container);
        this.topContainer = (LinearLayout)this.controllerView.findViewById(R.id.top_container);
        this.videoProgress = (SeekBar)this.controllerView.findViewById(R.id.seekBar);
        this.videoProgress.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        this.totalTime = (TextView)this.controllerView.findViewById(R.id.total_time);
        this.currTime = (TextView)this.controllerView.findViewById(R.id.curr_time);
        this.backButton = (ImageView)this.controllerView.findViewById(R.id.back);
        this.backButton.setOnClickListener((View.OnClickListener)this);
        this.lock = (ImageView)this.controllerView.findViewById(R.id.lock);
        this.lock.setOnClickListener((View.OnClickListener)this);
        this.thumb = (ImageView)this.controllerView.findViewById(R.id.thumb);
        this.thumb.setOnClickListener((View.OnClickListener)this);
        this.playButton = (ImageView)this.controllerView.findViewById(R.id.iv_play);
        this.playButton.setOnClickListener((View.OnClickListener)this);
        this.startPlayButton = (ImageView)this.controllerView.findViewById(R.id.start_play);
        this.loadingProgress = (ProgressBar)this.controllerView.findViewById(R.id.loading);
        this.bottomProgress = (ProgressBar)this.controllerView.findViewById(R.id.bottom_progress);
        ImageView rePlayButton = (ImageView)this.controllerView.findViewById(R.id.iv_replay);
        rePlayButton.setOnClickListener((View.OnClickListener)this);
        this.completeContainer = (LinearLayout)this.controllerView.findViewById(R.id.complete_container);
        this.completeContainer.setOnClickListener((View.OnClickListener)this);
        this.title = (MarqueeTextView)this.controllerView.findViewById(R.id.title);
        this.sysTime = (TextView)this.controllerView.findViewById(R.id.sys_time);
        this.batteryLevel = (ImageView)this.controllerView.findViewById(R.id.iv_battery);
        this.mBatteryReceiver = new BatteryReceiver(this.batteryLevel);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.getContext().unregisterReceiver((BroadcastReceiver)this.mBatteryReceiver);
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.getContext().registerReceiver((BroadcastReceiver)this.mBatteryReceiver, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
    }

    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.fullscreen || i == R.id.back) {
            this.doStartStopFullScreen();
        } else if (i == R.id.lock) {
            this.doLockUnlock();
        } else if (i == R.id.iv_play || i == R.id.thumb || i == R.id.iv_replay) {
            this.doPauseResume();
        }
    }

    public void showTitle() {
        this.title.setVisibility(0);
    }

    @Override
    public void setPlayerState(int playerState) {
        switch (playerState) {
            case 10: {
                L.e("PLAYER_NORMAL");
                if (this.isLocked) {
                    return;
                }
                this.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                this.gestureEnabled = false;
                this.fullScreenButton.setSelected(false);
                this.backButton.setVisibility(8);
                this.lock.setVisibility(8);
                this.title.setVisibility(4);
                this.sysTime.setVisibility(8);
                this.batteryLevel.setVisibility(8);
                break;
            }
            case 11: {
                L.e("PLAYER_FULL_SCREEN");
                if (this.isLocked) {
                    return;
                }
                this.gestureEnabled = true;
                this.fullScreenButton.setSelected(true);
                this.backButton.setVisibility(0);
                this.title.setVisibility(0);
                this.sysTime.setVisibility(0);
                this.batteryLevel.setVisibility(0);
                if (this.mShowing) {
                    this.lock.setVisibility(0);
                    break;
                }
                this.lock.setVisibility(8);
            }
        }
    }

    @Override
    public void setPlayState(int playState) {
        super.setPlayState(playState);
        switch (playState) {
            case 0: {
                L.e("STATE_IDLE");
                this.hide();
                this.isLocked = false;
                this.lock.setSelected(false);
                this.mediaPlayer.setLock(false);
                this.completeContainer.setVisibility(8);
                this.bottomProgress.setVisibility(8);
                this.loadingProgress.setVisibility(8);
                this.startPlayButton.setVisibility(0);
                this.thumb.setVisibility(0);
                break;
            }
            case 3: {
                L.e("STATE_PLAYING");
                this.post(this.mShowProgress);
                this.playButton.setSelected(true);
                this.completeContainer.setVisibility(8);
                this.thumb.setVisibility(8);
                this.startPlayButton.setVisibility(8);
                break;
            }
            case 4: {
                L.e("STATE_PAUSED");
                this.playButton.setSelected(false);
                this.startPlayButton.setVisibility(8);
                break;
            }
            case 1: {
                L.e("STATE_PREPARING");
                this.completeContainer.setVisibility(8);
                this.startPlayButton.setVisibility(8);
                this.loadingProgress.setVisibility(0);
                break;
            }
            case 2: {
                L.e("STATE_PREPARED");
                if (!this.isLive) {
                    this.bottomProgress.setVisibility(0);
                }
                this.loadingProgress.setVisibility(8);
                this.startPlayButton.setVisibility(8);
                break;
            }
            case -1: {
                L.e("STATE_ERROR");
                this.startPlayButton.setVisibility(8);
                break;
            }
            case 6: {
                L.e("STATE_BUFFERING");
                this.startPlayButton.setVisibility(8);
                this.loadingProgress.setVisibility(0);
                break;
            }
            case 7: {
                this.loadingProgress.setVisibility(8);
                this.startPlayButton.setVisibility(8);
                L.e("STATE_BUFFERED");
                break;
            }
            case 5: {
                L.e("STATE_PLAYBACK_COMPLETED");
                this.hide();
                this.startPlayButton.setVisibility(8);
                this.thumb.setVisibility(0);
                this.completeContainer.setVisibility(0);
                this.bottomProgress.setProgress(0);
                this.bottomProgress.setSecondaryProgress(0);
                this.isLocked = false;
                this.mediaPlayer.setLock(false);
            }
        }
    }

    private void doLockUnlock() {
        if (this.isLocked) {
            this.isLocked = false;
            this.mShowing = false;
            this.gestureEnabled = true;
            this.show();
            this.lock.setSelected(false);
            Toast.makeText((Context)this.getContext(), (int)R.string.unlocked, (int)0).show();
        } else {
            this.hide();
            this.isLocked = true;
            this.gestureEnabled = false;
            this.lock.setSelected(true);
            Toast.makeText((Context)this.getContext(), (int)R.string.locked, (int)0).show();
        }
        this.mediaPlayer.setLock(this.isLocked);
    }

    public void setLive() {
        this.isLive = true;
        this.bottomProgress.setVisibility(8);
        this.videoProgress.setVisibility(4);
        this.totalTime.setVisibility(4);
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
        this.isDragging = true;
        this.removeCallbacks(this.mShowProgress);
        this.removeCallbacks(this.mFadeOut);
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
        long duration = this.mediaPlayer.getDuration();
        long newPosition = duration * (long)seekBar.getProgress() / (long)this.videoProgress.getMax();
        this.mediaPlayer.seekTo((int)newPosition);
        this.isDragging = false;
        this.post(this.mShowProgress);
        this.show();
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
        if (!fromUser) {
            return;
        }
        long duration = this.mediaPlayer.getDuration();
        long newPosition = duration * (long)progress / (long)this.videoProgress.getMax();
        if (this.currTime != null) {
            this.currTime.setText((CharSequence)this.stringForTime((int)newPosition));
        }
    }

    @Override
    public void hide() {
        if (this.mShowing) {
            if (this.mediaPlayer.isFullScreen()) {
                this.lock.setVisibility(8);
                if (!this.isLocked) {
                    this.hideAllViews();
                }
            } else {
                this.hideAllViews();
            }
            if (!this.isLive && !this.isLocked) {
                this.bottomProgress.setVisibility(0);
                this.bottomProgress.startAnimation(this.showAnim);
            }
            this.mShowing = false;
        }
    }

    private void hideAllViews() {
        this.topContainer.setVisibility(8);
        this.topContainer.startAnimation(this.hideAnim);
        this.bottomContainer.setVisibility(8);
        this.bottomContainer.startAnimation(this.hideAnim);
    }

    private void show(int timeout) {
        if (!this.mShowing) {
            if (this.mediaPlayer.isFullScreen()) {
                this.lock.setVisibility(0);
                if (!this.isLocked) {
                    this.showAllViews();
                }
            } else {
                this.showAllViews();
            }
            if (!this.isLocked && !this.isLive) {
                this.bottomProgress.setVisibility(8);
                this.bottomProgress.startAnimation(this.hideAnim);
            }
            this.mShowing = true;
        }
        this.removeCallbacks(this.mFadeOut);
        if (timeout != 0) {
            this.postDelayed(this.mFadeOut, timeout);
        }
    }

    private void showAllViews() {
        this.bottomContainer.setVisibility(0);
        this.bottomContainer.startAnimation(this.showAnim);
        this.topContainer.setVisibility(0);
        this.topContainer.startAnimation(this.showAnim);
    }

    @Override
    public void show() {
        this.show(this.sDefaultTimeout);
    }

    @Override
    protected int setProgress() {
        if (this.mediaPlayer == null || this.isDragging) {
            return 0;
        }
        int position = this.mediaPlayer.getCurrentPosition();
        int duration = this.mediaPlayer.getDuration();
        if (this.videoProgress != null) {
            if (duration > 0) {
                this.videoProgress.setEnabled(true);
                int pos = (int)((double)position * 1.0 / (double)duration * (double)this.videoProgress.getMax());
                this.videoProgress.setProgress(pos);
                this.bottomProgress.setProgress(pos);
            } else {
                this.videoProgress.setEnabled(false);
            }
            int percent = this.mediaPlayer.getBufferPercentage();
            if (percent >= 95) {
                this.videoProgress.setSecondaryProgress(this.videoProgress.getMax());
                this.bottomProgress.setSecondaryProgress(this.bottomProgress.getMax());
            } else {
                this.videoProgress.setSecondaryProgress(percent * 10);
                this.bottomProgress.setSecondaryProgress(percent * 10);
            }
        }
        if (this.totalTime != null) {
            this.totalTime.setText((CharSequence)this.stringForTime(duration));
        }
        if (this.currTime != null) {
            this.currTime.setText((CharSequence)this.stringForTime(position));
        }
        if (this.sysTime != null) {
            this.sysTime.setText((CharSequence)this.getCurrentSystemTime());
        }
        if (this.title != null && TextUtils.isEmpty((CharSequence)this.title.getText())) {
            this.title.setText(this.mediaPlayer.getTitle());
        }
        return position;
    }

    @Override
    protected void slideToChangePosition(float deltaX) {
        if (this.isLive) {
            this.mNeedSeek = false;
        } else {
            super.slideToChangePosition(deltaX);
        }
    }

    public ImageView getThumb() {
        return this.thumb;
    }

    @Override
    public boolean onBackPressed() {
        if (this.isLocked) {
            this.show();
            Toast.makeText((Context)this.getContext(), (int)R.string.lock_tip, (int)0).show();
            return true;
        }
        if (this.mediaPlayer.isFullScreen()) {
            WindowUtil.scanForActivity(this.getContext()).setRequestedOrientation(1);
            this.mediaPlayer.stopFullScreen();
            this.setPlayerState(10);
            return true;
        }
        return super.onBackPressed();
    }
}

