/*
 * Decompiled with CFR 0.152.
 */
package top.defaults.logger;

import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;

public final class Logger {
    private static final String DEFAULT_TAG = "TopDefaultsLogger";
    private static String tagPrefix = "TopDefaultsLogger";
    private static int level = 2;
    private static String logFilePath;
    private static int logFileSizeInMegabytes;
    private static final String prevLogFileSuffix = "-prev";
    private static BufferedWriter logWriter;
    private static ExecutorService executorService;
    private static Timer timer;
    private static TimerTask scheduledFlushTask;
    private static TimerTask scheduledCloseTask;
    private static SparseArray<String> PRIORITY_MAP;

    public static void setLevel(int level) {
        Logger.level = level;
    }

    public static int getLevel() {
        return level;
    }

    public static void setTagPrefix(String tagPrefix) {
        Logger.tagPrefix = tagPrefix;
    }

    public static void setLogFile(String filePath) {
        logFilePath = filePath;
        if (filePath == null) {
            executorService.shutdown();
            timer.cancel();
            return;
        }
        if (executorService == null) {
            executorService = Executors.newSingleThreadExecutor();
        }
        if (timer == null) {
            timer = new Timer();
        }
    }

    public static void setLogFileMaxSizeInMegabytes(int sizeInMegabytes) {
        logFileSizeInMegabytes = sizeInMegabytes;
    }

    public static void v(String message, Object ... args) {
        Logger.vWithTag(Logger.realTag(), message, args);
    }

    public static void d(String message, Object ... args) {
        Logger.dWithTag(Logger.realTag(), message, args);
    }

    public static void i(String message, Object ... args) {
        Logger.iWithTag(Logger.realTag(), message, args);
    }

    public static void w(String message, Object ... args) {
        Logger.wWithTag(Logger.realTag(), message, args);
    }

    public static void e(String message, Object ... args) {
        Logger.eWithTag(Logger.realTag(), message, args);
    }

    public static void wtf(String message, Object ... args) {
        Logger.wtfWithTag(Logger.realTag(), message, args);
    }

    public static void vWithTag(String tag, String message, Object ... args) {
        Logger.log(2, tag, message, args);
    }

    public static void dWithTag(String tag, String message, Object ... args) {
        Logger.log(3, tag, message, args);
    }

    public static void iWithTag(String tag, String message, Object ... args) {
        Logger.log(4, tag, message, args);
    }

    public static void wWithTag(String tag, String message, Object ... args) {
        Logger.log(5, tag, message, args);
    }

    public static void eWithTag(String tag, String message, Object ... args) {
        Logger.log(6, tag, message, args);
    }

    public static void wtfWithTag(String tag, String message, Object ... args) {
        Logger.log(7, tag, message, args);
    }

    public static void logThreadStart() {
        Logger.dWithTag(Logger.realTag(), ">>>>>>>> " + Thread.currentThread().getClass() + " start running >>>>>>>>", new Object[0]);
    }

    public static void logThreadFinish() {
        Logger.dWithTag(Logger.realTag(), "<<<<<<<< " + Thread.currentThread().getClass() + " finished running <<<<<<<<", new Object[0]);
    }

    private static void log(int priority, String tag, String message, Object ... args) {
        if (level > priority && !Log.isLoggable((String)tagPrefix, (int)3)) {
            return;
        }
        message = Logger.formatMessage(message, args);
        if (priority == 7) {
            Log.wtf((String)tag, (String)message);
        } else {
            Log.println((int)priority, (String)tag, (String)message);
        }
        try {
            Logger.writeLogFile(Logger.priorityAbbr(priority) + "/" + tag + "\t" + message);
        }
        catch (Exception ignored) {
            // empty catch block
        }
    }

    private static String priorityAbbr(int priority) {
        return (String)PRIORITY_MAP.get(priority);
    }

    public static void logWithTimber(int priority, String customTag, String message) {
        String tag = Logger.realTimberTag(customTag);
        switch (priority) {
            case 2: {
                Logger.vWithTag(tag, message, new Object[0]);
                break;
            }
            case 3: {
                Logger.dWithTag(tag, message, new Object[0]);
                break;
            }
            case 4: {
                Logger.iWithTag(tag, message, new Object[0]);
                break;
            }
            case 5: {
                Logger.wWithTag(tag, message, new Object[0]);
                break;
            }
            case 6: {
                Logger.eWithTag(tag, message, new Object[0]);
                break;
            }
            case 7: {
                Logger.wtfWithTag(tag, message, new Object[0]);
                break;
            }
        }
    }

    private static String formatMessage(String message, Object[] args) {
        if (args != null && args.length > 0) {
            message = String.format(message, args);
        }
        return message;
    }

    private static void writeLogFile(String message) {
        if (logFilePath != null) {
            SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
            String strDate = sdfDate.format(new Date());
            String line = strDate + " " + message;
            executorService.submit(new LogWriterRunnable(line));
            if (scheduledFlushTask != null) {
                scheduledFlushTask.cancel();
            }
            scheduledFlushTask = new TimerTask(){

                @Override
                public void run() {
                    FutureTask<Void> flushTask = new FutureTask<Void>(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            logWriter.flush();
                            return null;
                        }
                    });
                    executorService.submit(flushTask);
                }
            };
            timer.schedule(scheduledFlushTask, 1000L);
            if (scheduledCloseTask != null) {
                scheduledCloseTask.cancel();
            }
            scheduledCloseTask = new TimerTask(){

                @Override
                public void run() {
                    FutureTask<Void> closeTask = new FutureTask<Void>(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            logWriter.close();
                            logWriter = null;
                            return null;
                        }
                    });
                    executorService.submit(closeTask);
                }
            };
            timer.schedule(scheduledCloseTask, 60000L);
        }
    }

    private static String realTag() {
        return tagPrefix + "|" + Logger.getLineInfo();
    }

    private static String realTimberTag(String timberTag) {
        return (TextUtils.isEmpty((CharSequence)timberTag) ? tagPrefix : timberTag) + "|" + Logger.getLineInfoBypassTimber();
    }

    private static String getLineInfo() {
        StackTraceElement[] stackTraceElement = Thread.currentThread().getStackTrace();
        String fileName = stackTraceElement[5].getFileName();
        int lineNumber = stackTraceElement[5].getLineNumber();
        return ".(" + fileName + ":" + lineNumber + ")";
    }

    private static String getLineInfoBypassTimber() {
        StackTraceElement[] stackTraceElement = Thread.currentThread().getStackTrace();
        int offset = Logger.getStackOffsetBypassTimber(stackTraceElement);
        if (offset < 0) {
            return "";
        }
        String fileName = stackTraceElement[offset].getFileName();
        int lineNumber = stackTraceElement[offset].getLineNumber();
        return ".(" + fileName + ":" + lineNumber + ")";
    }

    private static int getStackOffsetBypassTimber(StackTraceElement[] stackTraceElements) {
        for (int i = 6; i < stackTraceElements.length; ++i) {
            StackTraceElement e = stackTraceElements[i];
            String name = e.getClassName();
            if (name.startsWith("timber.log.Timber")) continue;
            return i;
        }
        return -1;
    }

    static {
        logFileSizeInMegabytes = 2;
        PRIORITY_MAP = new SparseArray();
        PRIORITY_MAP.append(2, (Object)"V");
        PRIORITY_MAP.append(3, (Object)"D");
        PRIORITY_MAP.append(4, (Object)"I");
        PRIORITY_MAP.append(5, (Object)"W");
        PRIORITY_MAP.append(6, (Object)"E");
        PRIORITY_MAP.append(7, (Object)"X");
    }

    private static class LogWriterRunnable
    implements Runnable {
        private final String line;

        LogWriterRunnable(String line) {
            this.line = line;
        }

        @Override
        public void run() {
            try {
                if (logWriter == null) {
                    logWriter = new BufferedWriter(new FileWriter(logFilePath, true));
                }
                logWriter.append(this.line);
                logWriter.newLine();
            }
            catch (IOException ignored) {
                // empty catch block
            }
            File currentFile = new File(logFilePath);
            if (currentFile.length() >= (long)(logFileSizeInMegabytes * 1024 * 1024)) {
                File prevFile = new File(logFilePath + Logger.prevLogFileSuffix);
                currentFile.renameTo(prevFile);
                try {
                    logWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                logWriter = null;
            }
        }
    }
}

