/*
 * Decompiled with CFR 0.152.
 */
package top.defaults.drawabletoolbox;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0004H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0014J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0004H\u0016J\u0012\u0010\u0010\u001a\u00020\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ltop/defaults/drawabletoolbox/FlipDrawable;", "Landroid/graphics/drawable/Drawable;", "drawable", "orientation", "", "(Landroid/graphics/drawable/Drawable;I)V", "draw", "", "canvas", "Landroid/graphics/Canvas;", "getOpacity", "onLevelChange", "", "level", "setAlpha", "alpha", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "Companion", "drawabletoolbox_release"})
public final class FlipDrawable
extends Drawable {
    private Drawable drawable;
    private int orientation;
    public static final int ORIENTATION_HORIZONTAL = 0;
    public static final int ORIENTATION_VERTICAL = 1;
    public static final Companion Companion = new Companion(null);

    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        int saveCount = canvas.save();
        if (this.orientation == 1) {
            canvas.scale(1.0f, -1.0f, (float)(canvas.getWidth() / 2), (float)(canvas.getHeight() / 2));
        } else {
            canvas.scale(-1.0f, 1.0f, (float)(canvas.getWidth() / 2), (float)(canvas.getHeight() / 2));
        }
        this.drawable.setBounds(new Rect(0, 0, canvas.getWidth(), canvas.getHeight()));
        this.drawable.draw(canvas);
        canvas.restoreToCount(saveCount);
    }

    protected boolean onLevelChange(int level) {
        this.drawable.setLevel(level);
        this.invalidateSelf();
        return true;
    }

    public void setAlpha(int alpha) {
        this.drawable.setAlpha(alpha);
    }

    public int getOpacity() {
        return this.drawable.getOpacity();
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.drawable.setColorFilter(colorFilter);
    }

    public FlipDrawable(@NotNull Drawable drawable, int orientation) {
        Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
        this.drawable = drawable;
        this.orientation = orientation;
    }

    public /* synthetic */ FlipDrawable(Drawable drawable, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(drawable, n);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ltop/defaults/drawabletoolbox/FlipDrawable$Companion;", "", "()V", "ORIENTATION_HORIZONTAL", "", "ORIENTATION_VERTICAL", "drawabletoolbox_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

