/*
 * Decompiled with CFR 0.152.
 */
package top.defaults.checkerboarddrawable;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

public class CheckerboardDrawable
extends Drawable {
    private Paint paint = new Paint(1);
    private int size;
    private int colorOdd;
    private int colorEven;

    public static CheckerboardDrawable create() {
        return new CheckerboardDrawable(new Builder());
    }

    private CheckerboardDrawable(Builder builder) {
        this.size = builder.size;
        this.colorOdd = builder.colorOdd;
        this.colorEven = builder.colorEven;
        this.configurePaint();
    }

    private void configurePaint() {
        Bitmap bitmap = Bitmap.createBitmap((int)(this.size * 2), (int)(this.size * 2), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Paint bitmapPaint = new Paint(1);
        bitmapPaint.setStyle(Paint.Style.FILL);
        Canvas canvas = new Canvas(bitmap);
        Rect rect = new Rect(0, 0, this.size, this.size);
        bitmapPaint.setColor(this.colorOdd);
        canvas.drawRect(rect, bitmapPaint);
        rect.offset(this.size, this.size);
        canvas.drawRect(rect, bitmapPaint);
        bitmapPaint.setColor(this.colorEven);
        rect.offset(-this.size, 0);
        canvas.drawRect(rect, bitmapPaint);
        rect.offset(this.size, -this.size);
        canvas.drawRect(rect, bitmapPaint);
        this.paint.setShader((Shader)new BitmapShader(bitmap, Shader.TileMode.REPEAT, Shader.TileMode.REPEAT));
    }

    public void draw(@NonNull Canvas canvas) {
        canvas.drawPaint(this.paint);
    }

    public void setAlpha(int alpha) {
        this.paint.setAlpha(alpha);
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.paint.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return -1;
    }

    public static final class Builder {
        private int size = 40;
        private int colorOdd = -4013374;
        private int colorEven = -789517;

        public Builder size(int size) {
            this.size = size;
            return this;
        }

        public Builder colorOdd(int color) {
            this.colorOdd = color;
            return this;
        }

        public Builder colorEven(int color) {
            this.colorEven = color;
            return this;
        }

        public CheckerboardDrawable build() {
            return new CheckerboardDrawable(this);
        }
    }
}

