/*
 * Decompiled with CFR 0.152.
 */
package top.defaults.camera;

import android.support.annotation.NonNull;

public class Size
implements Comparable<Size> {
    private final int width;
    private final int height;

    Size(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof Size) {
            Size size = (Size)o;
            return this.width == size.width && this.height == size.height;
        }
        return false;
    }

    public String toString() {
        return this.width + "x" + this.height;
    }

    public int hashCode() {
        return this.height ^ (this.width << 16 | this.width >>> 16);
    }

    @Override
    public int compareTo(@NonNull Size another) {
        int anotherArea;
        int area = this.getAreaSize();
        if (area != (anotherArea = another.getAreaSize())) {
            return area - anotherArea;
        }
        return this.width - another.width;
    }

    int getAreaSize() {
        return this.width * this.height;
    }
}

