/*
 * Decompiled with CFR 0.152.
 */
package top.defaults.camera;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import top.defaults.camera.Error;
import top.defaults.camera.Photographer;

class CallbackHandler
extends Handler {
    private static final int CALLBACK_ON_DEVICE_CONFIGURED = 1;
    private static final int CALLBACK_ON_PREVIEW_STARTED = 2;
    private static final int CALLBACK_ON_ZOOM_CHANGED = 3;
    private static final int CALLBACK_ON_PREVIEW_STOPPED = 4;
    private static final int CALLBACK_ON_START_RECORDING = 5;
    private static final int CALLBACK_ON_FINISH_RECORDING = 6;
    private static final int CALLBACK_ON_SHOT_FINISHED = 7;
    private static final int CALLBACK_ON_ERROR = 8;
    private Photographer.OnEventListener onEventListener;

    CallbackHandler(Context context) {
        super(context.getMainLooper());
    }

    void setOnEventListener(Photographer.OnEventListener listener) {
        this.onEventListener = listener;
    }

    public void handleMessage(Message msg) {
        if (this.onEventListener == null) {
            return;
        }
        switch (msg.what) {
            case 1: {
                this.onEventListener.onDeviceConfigured();
                break;
            }
            case 2: {
                this.onEventListener.onPreviewStarted();
                break;
            }
            case 3: {
                this.onEventListener.onZoomChanged(((Float)msg.obj).floatValue());
                break;
            }
            case 4: {
                this.onEventListener.onPreviewStopped();
                break;
            }
            case 5: {
                this.onEventListener.onStartRecording();
                break;
            }
            case 6: {
                this.onEventListener.onFinishRecording((String)msg.obj);
                break;
            }
            case 7: {
                this.onEventListener.onShotFinished((String)msg.obj);
                break;
            }
            case 8: {
                this.onEventListener.onError((Error)msg.obj);
                break;
            }
        }
    }

    void onDeviceConfigured() {
        Message.obtain((Handler)this, (int)1).sendToTarget();
    }

    void onPreviewStarted() {
        Message.obtain((Handler)this, (int)2).sendToTarget();
    }

    void onZoomChanged(float zoom) {
        Message.obtain((Handler)this, (int)3, (Object)Float.valueOf(zoom)).sendToTarget();
    }

    void onPreviewStopped() {
        Message.obtain((Handler)this, (int)4).sendToTarget();
    }

    void onStartRecording() {
        Message.obtain((Handler)this, (int)5).sendToTarget();
    }

    void onFinishRecording(String filePath) {
        Message.obtain((Handler)this, (int)6, (Object)filePath).sendToTarget();
    }

    void onShotFinished(String filePath) {
        Message.obtain((Handler)this, (int)7, (Object)filePath).sendToTarget();
    }

    void onError(Error error) {
        Message.obtain((Handler)this, (int)8, (Object)error).sendToTarget();
    }
}

