/*
 * Decompiled with CFR 0.152.
 */
package top.defaults.camera;

import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.support.annotation.NonNull;

abstract class ImageCaptureCallback
extends CameraCaptureSession.CaptureCallback {
    static final int STATE_PREVIEW = 0;
    static final int STATE_LOCKING = 1;
    static final int STATE_LOCKED = 2;
    static final int STATE_PRECAPTURE = 3;
    static final int STATE_WAITING = 4;
    static final int STATE_CAPTURING = 5;
    private int state;

    ImageCaptureCallback() {
    }

    void setState(int state) {
        this.state = state;
    }

    public void onCaptureProgressed(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull CaptureResult partialResult) {
        this.process(partialResult);
    }

    public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
        this.process((CaptureResult)result);
    }

    private void process(@NonNull CaptureResult result) {
        switch (this.state) {
            case 1: {
                Integer af = (Integer)result.get(CaptureResult.CONTROL_AF_STATE);
                if (af == null || af != 4 && af != 5) break;
                Integer ae = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
                if (ae == null || ae == 2) {
                    this.setState(5);
                    this.onReady();
                    break;
                }
                this.setState(2);
                this.onPrecaptureRequired();
                break;
            }
            case 3: {
                Integer ae = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
                if (ae != null && ae != 5 && ae != 4 && ae != 2) break;
                this.setState(4);
                break;
            }
            case 4: {
                Integer ae = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
                if (ae != null && ae == 5) break;
                this.setState(5);
                this.onReady();
                break;
            }
        }
    }

    abstract void onReady();

    abstract void onPrecaptureRequired();
}

