/*
 * Decompiled with CFR 0.152.
 */
package top.defaults.camera;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;

public interface CanvasDrawer {
    public Paint[] initPaints();

    public void draw(Canvas var1, Point var2, Paint[] var3);

    public static class DefaultCanvasDrawer
    implements CanvasDrawer {
        @Override
        public Paint[] initPaints() {
            Paint focusPaint = new Paint(1);
            focusPaint.setStyle(Paint.Style.STROKE);
            focusPaint.setStrokeWidth(2.0f);
            focusPaint.setColor(-1);
            return new Paint[]{focusPaint};
        }

        @Override
        public void draw(Canvas canvas, Point point, Paint[] paints) {
            if (paints == null || paints.length == 0) {
                return;
            }
            canvas.drawCircle((float)point.x, (float)point.y, 150.0f, paints[0]);
        }
    }
}

