/*
 * Decompiled with CFR 0.152.
 */
package top.defaults.camera;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Environment;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import top.defaults.camera.Error;

public class Utils {
    private static Pattern pattern = Pattern.compile("^#(\\d+), (.+)");
    private static String fileDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM) + "/TopDefaultsCamera/";

    static String exceptionMessage(int code, String message) {
        return String.format(Locale.getDefault(), "#%d, %s", code, message);
    }

    private static int codeFromThrowable(Throwable throwable, int fallback) {
        Matcher matcher;
        int errorCode = fallback;
        String message = throwable.getMessage();
        if (message != null && (matcher = pattern.matcher(message)).find()) {
            errorCode = Integer.parseInt(matcher.group(1));
        }
        return errorCode;
    }

    private static String messageFromThrowable(Throwable throwable) {
        String message = throwable.getMessage();
        if (message == null) {
            message = throwable.toString();
        } else {
            Matcher matcher = pattern.matcher(message);
            if (matcher.find()) {
                message = matcher.group(2);
            }
        }
        return message;
    }

    static Error errorFromThrowable(Throwable throwable) {
        return Utils.errorFromThrowable(throwable, -1);
    }

    private static Error errorFromThrowable(Throwable throwable, int fallback) {
        return new Error(Utils.codeFromThrowable(throwable, fallback), Utils.messageFromThrowable(throwable));
    }

    static boolean napInterrupted() {
        return !Utils.sleep(1L);
    }

    private static boolean sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    static boolean getBoolean(Map<String, Object> params, String key, boolean defaultValue) {
        boolean value = defaultValue;
        if (params == null) {
            return value;
        }
        Object valueObject = params.get(key);
        if (valueObject instanceof Boolean) {
            value = (Boolean)valueObject;
        }
        return value;
    }

    static int getInt(Map<String, Object> params, String key, int defaultValue) {
        int value = defaultValue;
        if (params == null) {
            return value;
        }
        Object valueObject = params.get(key);
        if (valueObject instanceof Integer) {
            value = (Integer)valueObject;
        }
        return value;
    }

    static String getString(Map<String, Object> params, String key, String defaultValue) {
        String value = defaultValue;
        if (params == null) {
            return value;
        }
        Object valueObject = params.get(key);
        if (valueObject instanceof String && (value = (String)valueObject).length() == 0) {
            value = defaultValue;
        }
        return value;
    }

    public static void addMediaToGallery(Context context, String photoPath) {
        Intent mediaScanIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
        File photoFile = new File(photoPath);
        Uri contentUri = Uri.fromFile((File)photoFile);
        mediaScanIntent.setData(contentUri);
        context.sendBroadcast(mediaScanIntent);
    }

    static String getImageFilePath() throws IOException {
        return Utils.getFilePath(".jpg");
    }

    static String getVideoFilePath() throws IOException {
        return Utils.getFilePath(".mp4");
    }

    static void setFileDir(String fileDir) {
        Utils.fileDir = fileDir;
    }

    private static String getFilePath(String fileSuffix) throws IOException {
        boolean result;
        File dir = new File(fileDir);
        if (!dir.exists() && !(result = dir.mkdirs())) {
            throw new IOException(Utils.exceptionMessage(4, "Unable to create folder"));
        }
        return dir.getAbsolutePath() + "/" + System.currentTimeMillis() + fileSuffix;
    }
}

