/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.httpclient;

import com.vk.api.sdk.client.ClientResponse;
import com.vk.api.sdk.client.TransportClient;
import com.vk.api.sdk.httpclient.ConnectionsSupervisor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportClientHttp
implements TransportClient {
    private static final Logger LOG = LoggerFactory.getLogger(TransportClientHttp.class);
    private static final String ENCODING = "UTF-8";
    private static final String CONTENT_TYPE = "application/x-www-form-urlencoded";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String USER_AGENT = "Java VK SDK/0.5.2";
    private static final int MAX_SIMULTANEOUS_CONNECTIONS = 300;
    private static final int FULL_CONNECTION_TIMEOUT_S = 60;
    private static final int CONNECTION_TIMEOUT_MS = 5000;
    private static final int SOCKET_TIMEOUT_MS = 60000;
    private static final ConnectionsSupervisor SUPERVISOR = new ConnectionsSupervisor();
    private static TransportClientHttp instance;
    private static HttpClient httpClient;

    public TransportClientHttp() {
        BasicCookieStore cookieStore = new BasicCookieStore();
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(5000).setConnectionRequestTimeout(5000).setCookieSpec("standard").build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(300);
        connectionManager.setDefaultMaxPerRoute(300);
        httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfig).setDefaultCookieStore((CookieStore)cookieStore).setUserAgent(USER_AGENT).build();
    }

    public static TransportClientHttp getInstance() {
        if (instance == null) {
            instance = new TransportClientHttp();
        }
        return instance;
    }

    private static Map<String, String> getHeaders(Header[] headers) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Header header : headers) {
            result.put(header.getName(), header.getValue());
        }
        return result;
    }

    /*
     * Loose catch block
     */
    private ClientResponse call(HttpPost request) throws IOException {
        SocketException exception = null;
        int i = 0;
        while (i < 3) {
            ClientResponse clientResponse;
            Throwable throwable;
            InputStream content;
            block18: {
                block19: {
                    SUPERVISOR.addRequest((HttpUriRequest)request);
                    long startTime = System.currentTimeMillis();
                    HttpResponse response = httpClient.execute((HttpUriRequest)request);
                    long endTime = System.currentTimeMillis();
                    long resultTime = endTime - startTime;
                    content = response.getEntity().getContent();
                    throwable = null;
                    String result = IOUtils.toString((InputStream)content, (String)ENCODING);
                    Map<String, String> headers = TransportClientHttp.getHeaders(response.getAllHeaders());
                    this.logRequest(request, response, headers, result, resultTime);
                    clientResponse = new ClientResponse(response.getStatusLine().getStatusCode(), result, headers);
                    if (content == null) break block18;
                    if (throwable == null) break block19;
                    try {
                        content.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                content.close();
            }
            SUPERVISOR.removeRequest((HttpUriRequest)request);
            return clientResponse;
            catch (Throwable throwable3) {
                try {
                    try {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (content != null) {
                                if (throwable != null) {
                                    try {
                                        content.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    content.close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable6) {
                        SUPERVISOR.removeRequest((HttpUriRequest)request);
                        throw throwable6;
                    }
                }
                catch (SocketException e) {
                    this.logRequest(request);
                    LOG.warn("Network troubles", (Throwable)e);
                    exception = e;
                    ++i;
                }
            }
        }
        throw exception;
    }

    private void logRequest(HttpPost request) throws IOException {
        this.logRequest(request, null, null, null, null);
    }

    private void logRequest(HttpPost request, HttpResponse response, Map<String, String> headers, String body, Long time) throws IOException {
        if (LOG.isDebugEnabled()) {
            Header contentType = request.getFirstHeader(CONTENT_TYPE_HEADER);
            String payload = "-";
            if (contentType != null && contentType.getValue().equalsIgnoreCase(CONTENT_TYPE) && request.getEntity() != null) {
                payload = IOUtils.toString((InputStream)request.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            }
            StringBuilder builder = new StringBuilder("\n").append("Request:\n").append("\t").append("Method: ").append(request.getMethod()).append("\n").append("\t").append("URI: ").append(request.getURI()).append("\n").append("\t").append("Payload: ").append(payload).append("\n").append("\t").append("Time: ").append(time != null ? time : "-").append("\n");
            if (response != null) {
                builder.append("Response:\n").append("\t").append("Status: ").append(response.getStatusLine().toString()).append("\n").append("\t").append("Headers: ").append(headers != null ? headers : "-").append("\n").append("\t").append("Body: ").append(body != null ? body : "-").append("\n");
            }
            LOG.debug(builder.toString());
        } else if (LOG.isInfoEnabled()) {
            StringBuilder builder = new StringBuilder().append("Request: ").append(request.getURI().toURL().toString());
            if (time != null) {
                builder.append("\t\t").append(time);
            }
            LOG.info(builder.toString());
        }
    }

    @Override
    public ClientResponse post(String url, String body) throws IOException {
        HttpPost request = new HttpPost(url);
        request.setHeader(CONTENT_TYPE_HEADER, CONTENT_TYPE);
        if (body != null) {
            request.setEntity((HttpEntity)new StringEntity(body));
        }
        return this.call(request);
    }

    @Override
    public ClientResponse post(String url) throws IOException {
        HttpPost request = new HttpPost(url);
        request.setHeader(CONTENT_TYPE_HEADER, CONTENT_TYPE);
        return this.call(request);
    }

    @Override
    public boolean isCached() {
        return false;
    }

    @Override
    public boolean isTest() {
        return false;
    }

    @Override
    public ClientResponse post(String url, String fileName, File file) throws IOException {
        HttpPost request = new HttpPost(url);
        FileBody fileBody = new FileBody(file);
        HttpEntity entity = MultipartEntityBuilder.create().addPart(fileName, (ContentBody)fileBody).build();
        request.setEntity(entity);
        return this.call(request);
    }
}

