/*
 * Decompiled with CFR 0.152.
 */
package com.fonfon.geohash;

import com.fonfon.geohash.BoundingBox;
import com.fonfon.geohash.GeoHash;

public class TwoGeoHashBoundingBox {
    private BoundingBox boundingBox;
    private GeoHash topLeftHash;
    private GeoHash bottomRightHash;

    public static TwoGeoHashBoundingBox fromBoundingBox(BoundingBox box, int numberOfCharacters) {
        GeoHash topLeft = GeoHash.fromLocation(box.getTopLeft(), numberOfCharacters);
        GeoHash bottomRight = GeoHash.fromLocation(box.getBottomRight(), numberOfCharacters);
        return new TwoGeoHashBoundingBox(topLeft, bottomRight);
    }

    public static TwoGeoHashBoundingBox fromString(String base32) {
        if (base32.length() > 12) {
            throw new IllegalArgumentException("A geohash can only be 12 character long.");
        }
        boolean isEven = base32.length() % 2 == 1;
        GeoHash topLeft = GeoHash.fromString(base32 + (isEven ? "p" : "b"));
        GeoHash bottomRight = GeoHash.fromString(base32 + (isEven ? "b" : "p"));
        return new TwoGeoHashBoundingBox(topLeft, bottomRight);
    }

    public static TwoGeoHashBoundingBox fromGeoHash(GeoHash geoHash) {
        String hash = geoHash.toString();
        boolean isEven = hash.length() % 2 == 1;
        GeoHash topLeft = GeoHash.fromString(hash + (isEven ? "p" : "b"));
        GeoHash bottomRight = GeoHash.fromString(hash + (isEven ? "b" : "p"));
        return new TwoGeoHashBoundingBox(topLeft, bottomRight);
    }

    public static TwoGeoHashBoundingBox fromThoGeoHashBoundingBoxString(String base32) {
        String bottomLeft = base32.substring(0, base32.length() / 2);
        String topRight = base32.substring(base32.length() / 2);
        return new TwoGeoHashBoundingBox(GeoHash.fromString(bottomLeft), GeoHash.fromString(topRight));
    }

    public TwoGeoHashBoundingBox(GeoHash topLeftHash, GeoHash bottomRightHash) {
        if (topLeftHash.getSignificantBits() != bottomRightHash.getSignificantBits()) {
            throw new IllegalArgumentException("Hashes have different precisions!");
        }
        this.topLeftHash = topLeftHash;
        this.bottomRightHash = bottomRightHash;
        this.boundingBox = new BoundingBox(topLeftHash.getBoundingBox().getTopLeft(), bottomRightHash.getBoundingBox().getBottomRight());
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public GeoHash getTopLeftHash() {
        return this.topLeftHash;
    }

    public GeoHash getBottomRightHash() {
        return this.bottomRightHash;
    }

    public String toString() {
        return this.topLeftHash.toString() + this.bottomRightHash.toString();
    }
}

