/*
 * Decompiled with CFR 0.152.
 */
package dreamspace.ads.sdk.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.Display;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.admanager.AdManagerAdRequest;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import dreamspace.ads.sdk.AdNetwork;
import dreamspace.ads.sdk.data.AdNetworkType;
import dreamspace.ads.sdk.gdpr.LegacyGDPR;
import java.util.List;

public class Tools {
    private static final String TAG = AdNetwork.class.getSimpleName();

    public static AdSize getAdSize(Activity activity) {
        Display display = activity.getWindowManager().getDefaultDisplay();
        DisplayMetrics outMetrics = new DisplayMetrics();
        display.getMetrics(outMetrics);
        float widthPixels = outMetrics.widthPixels;
        float density = outMetrics.density;
        int adWidth = (int)(widthPixels / density);
        return AdSize.getCurrentOrientationAnchoredAdaptiveBannerAdSize((Context)activity, (int)adWidth);
    }

    public static AdSize getAdSizeMREC() {
        return AdSize.MEDIUM_RECTANGLE;
    }

    public static AdRequest getAdRequest(Activity activity) {
        return new AdRequest.Builder().addNetworkExtrasBundle(AdMobAdapter.class, LegacyGDPR.getBundleAd(activity)).build();
    }

    @SuppressLint(value={"VisibleForTests"})
    public static AdManagerAdRequest getGoogleAdManagerRequest() {
        return new AdManagerAdRequest.Builder().build();
    }

    public static boolean contains(List<AdNetworkType> ad_networks, AdNetworkType ... value) {
        for (AdNetworkType t : value) {
            if (!ad_networks.contains((Object)t)) continue;
            return true;
        }
        return false;
    }

    public static int dpToPx(Context c, int dp) {
        Resources r = c.getResources();
        return Math.round(TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)r.getDisplayMetrics()));
    }

    public static void getGAID(final Context context) {
        if (!TextUtils.isEmpty((CharSequence)AdNetwork.GAID)) {
            return;
        }
        AsyncTask.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    AdvertisingIdClient.Info adInfo = AdvertisingIdClient.getAdvertisingIdInfo((Context)context);
                    Log.d((String)TAG, (String)("GAID : " + adInfo.getId()));
                    AdNetwork.GAID = adInfo.getId();
                }
                catch (Exception exception) {
                    Log.d((String)TAG, (String)"GAID Failed");
                }
            }
        });
    }
}

