/*
 * Decompiled with CFR 0.152.
 */
package dreamspace.ads.sdk.gdpr;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import com.google.ads.consent.ConsentForm;
import com.google.ads.consent.ConsentFormListener;
import com.google.ads.consent.ConsentInfoUpdateListener;
import com.google.ads.consent.ConsentInformation;
import com.google.ads.consent.ConsentStatus;
import java.net.MalformedURLException;
import java.net.URL;

public class LegacyGDPR {
    Activity activity;

    public LegacyGDPR(Activity activity) {
        this.activity = activity;
    }

    public static Bundle getBundleAd(Activity activity) {
        Bundle extras = new Bundle();
        ConsentInformation consentInformation = ConsentInformation.getInstance((Context)activity);
        if (consentInformation.getConsentStatus().equals((Object)ConsentStatus.NON_PERSONALIZED)) {
            extras.putString("npa", "1");
        }
        return extras;
    }

    public void updateLegacyGDPRConsentStatus(String adMobPublisherId, final String privacyPolicyUrl) {
        ConsentInformation consentInformation = ConsentInformation.getInstance((Context)this.activity);
        consentInformation.requestConsentInfoUpdate(new String[]{adMobPublisherId}, new ConsentInfoUpdateListener(){

            public void onConsentInfoUpdated(ConsentStatus consentStatus) {
                if (consentStatus == ConsentStatus.UNKNOWN) {
                    new GDPRForm(LegacyGDPR.this.activity).displayConsentForm(privacyPolicyUrl);
                }
            }

            public void onFailedToUpdateConsentInfo(String errorDescription) {
                Log.e((String)"GDPR", (String)errorDescription);
            }
        });
        Log.d((String)"GDPR", (String)"Legacy GDPR is selected");
    }

    private static class GDPRForm {
        private ConsentForm consentForm;
        Activity activity;

        private GDPRForm(Activity activity) {
            this.activity = activity;
        }

        private void displayConsentForm(String privacyPolicyUrl) {
            ConsentForm.Builder builder = new ConsentForm.Builder((Context)this.activity, this.getUrlPrivacyPolicy(privacyPolicyUrl));
            builder.withPersonalizedAdsOption();
            builder.withNonPersonalizedAdsOption();
            builder.withListener(new ConsentFormListener(){

                public void onConsentFormLoaded() {
                    consentForm.show();
                }

                public void onConsentFormOpened() {
                }

                public void onConsentFormClosed(ConsentStatus consentStatus, Boolean userPrefersAdFree) {
                    Log.e((String)"GDPR", (String)("Status : " + consentStatus));
                }

                public void onConsentFormError(String errorDescription) {
                    Log.e((String)"GDPR", (String)errorDescription);
                }
            });
            this.consentForm = builder.build();
            this.consentForm.load();
        }

        private URL getUrlPrivacyPolicy(String privacyPolicyUrl) {
            URL mUrl = null;
            try {
                mUrl = new URL(privacyPolicyUrl);
            }
            catch (MalformedURLException e) {
                Log.e((String)"GDPR", (String)e.getMessage());
            }
            return mUrl;
        }
    }
}

