/*
 * Decompiled with CFR 0.152.
 */
package dreamspace.ads.sdk.format;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.util.Log;
import androidx.annotation.NonNull;
import com.facebook.ads.Ad;
import com.facebook.ads.RewardedVideoAd;
import com.facebook.ads.RewardedVideoAdListener;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.admanager.AdManagerAdRequest;
import com.google.android.gms.ads.rewarded.RewardedAd;
import com.google.android.gms.ads.rewarded.RewardedAdLoadCallback;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.adunit.adapter.utility.AdInfo;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.model.Placement;
import com.ironsource.mediationsdk.sdk.LevelPlayRewardedVideoListener;
import dreamspace.ads.sdk.AdConfig;
import dreamspace.ads.sdk.AdNetwork;
import dreamspace.ads.sdk.data.AdNetworkType;
import dreamspace.ads.sdk.listener.AdRewardedListener;
import dreamspace.ads.sdk.utils.Tools;

public class RewardAdFormat {
    private static final String TAG = AdNetwork.class.getSimpleName();
    private RewardedAd adMobRewardedAd;
    private RewardedAd adManagerRewardedAd;
    private RewardedVideoAd fanRewardedVideoAd;
    private static int last_reward_index = 0;
    private final Activity activity;

    public RewardAdFormat(Activity activity) {
        this.activity = activity;
    }

    public void loadRewardAd(final int ad_index, final int retry_count, final AdRewardedListener listener) {
        if (retry_count > AdConfig.retry_from_start_max) {
            return;
        }
        last_reward_index = ad_index;
        final AdNetworkType type = AdConfig.ad_networks[ad_index];
        Log.d((String)TAG, (String)(type.name() + " rewarded loadRewardAd"));
        if (type == AdNetworkType.ADMOB || type == AdNetworkType.FAN_BIDDING_ADMOB) {
            RewardedAd.load((Context)this.activity, (String)AdConfig.ad_admob_rewarded_unit_id, (AdRequest)Tools.getAdRequest(this.activity), (RewardedAdLoadCallback)new RewardedAdLoadCallback(){

                public void onAdLoaded(@NonNull RewardedAd ad) {
                    Log.d((String)TAG, (String)(type.name() + " rewarded onAdLoaded"));
                    RewardAdFormat.this.adMobRewardedAd = ad;
                    RewardAdFormat.this.adMobRewardedAd.setFullScreenContentCallback(new FullScreenContentCallback(){

                        public void onAdDismissedFullScreenContent() {
                            super.onAdDismissedFullScreenContent();
                            Log.d((String)TAG, (String)(type.name() + " rewarded onAdDismissedFullScreenContent"));
                            RewardAdFormat.this.adMobRewardedAd = null;
                            RewardAdFormat.this.retryLoadReward(ad_index, retry_count, listener);
                            listener.onDismissed();
                        }

                        public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
                            super.onAdFailedToShowFullScreenContent(adError);
                            RewardAdFormat.this.adMobRewardedAd = null;
                        }
                    });
                }

                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                    Log.d((String)TAG, (String)(type.name() + " rewarded error : " + loadAdError.getMessage()));
                    RewardAdFormat.this.adMobRewardedAd = null;
                    RewardAdFormat.this.retryLoadReward(ad_index, retry_count, listener);
                }
            });
        } else if (type == AdNetworkType.MANAGER || type == AdNetworkType.FAN_BIDDING_AD_MANAGER) {
            RewardedAd.load((Context)this.activity, (String)AdConfig.ad_manager_rewarded_unit_id, (AdManagerAdRequest)Tools.getGoogleAdManagerRequest(), (RewardedAdLoadCallback)new RewardedAdLoadCallback(){

                public void onAdLoaded(@NonNull RewardedAd ad) {
                    Log.d((String)TAG, (String)(type.name() + " rewarded onAdLoaded"));
                    RewardAdFormat.this.adManagerRewardedAd = ad;
                    RewardAdFormat.this.adManagerRewardedAd.setFullScreenContentCallback(new FullScreenContentCallback(){

                        public void onAdDismissedFullScreenContent() {
                            super.onAdDismissedFullScreenContent();
                            Log.d((String)TAG, (String)(type.name() + " rewarded onAdDismissedFullScreenContent"));
                            RewardAdFormat.this.adManagerRewardedAd = null;
                            RewardAdFormat.this.retryLoadReward(ad_index, retry_count, listener);
                            listener.onDismissed();
                        }

                        public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
                            super.onAdFailedToShowFullScreenContent(adError);
                            RewardAdFormat.this.adManagerRewardedAd = null;
                        }
                    });
                }

                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                    Log.d((String)TAG, (String)(type.name() + " rewarded error : " + loadAdError.getMessage()));
                    RewardAdFormat.this.adManagerRewardedAd = null;
                    RewardAdFormat.this.retryLoadReward(ad_index, retry_count, listener);
                }
            });
        } else if (type == AdNetworkType.FAN) {
            this.fanRewardedVideoAd = new RewardedVideoAd((Context)this.activity, AdConfig.ad_fan_rewarded_unit_id);
            this.fanRewardedVideoAd.loadAd(this.fanRewardedVideoAd.buildLoadAdConfig().withAdListener(new RewardedVideoAdListener(){

                public void onRewardedVideoCompleted() {
                    Log.d((String)TAG, (String)(type.name() + " rewarded onComplete"));
                    listener.onComplete();
                }

                public void onRewardedVideoClosed() {
                    Log.d((String)TAG, (String)(type.name() + " rewarded onRewardedVideoClosed"));
                    RewardAdFormat.this.retryLoadReward(ad_index, retry_count, listener);
                    listener.onDismissed();
                }

                public void onError(Ad ad, com.facebook.ads.AdError adError) {
                    Log.d((String)TAG, (String)(type.name() + " rewarded onError : " + adError.getErrorMessage()));
                    RewardAdFormat.this.retryLoadReward(ad_index, retry_count, listener);
                }

                public void onAdLoaded(Ad ad) {
                    Log.d((String)TAG, (String)(type.name() + " rewarded onAdLoaded"));
                }

                public void onAdClicked(Ad ad) {
                }

                public void onLoggingImpression(Ad ad) {
                }
            }).build());
        } else if (type == AdNetworkType.IRONSOURCE || type == AdNetworkType.FAN_BIDDING_IRONSOURCE) {
            IronSource.setLevelPlayRewardedVideoListener((LevelPlayRewardedVideoListener)new LevelPlayRewardedVideoListener(){

                public void onAdAvailable(AdInfo adInfo) {
                    Log.d((String)TAG, (String)(type.name() + " rewarded onAdLoaded"));
                }

                public void onAdUnavailable() {
                }

                public void onAdOpened(AdInfo adInfo) {
                }

                public void onAdShowFailed(IronSourceError ironSourceError, AdInfo adInfo) {
                    Log.d((String)TAG, (String)(type.name() + " rewarded onAdShowFailed : " + ironSourceError.getErrorMessage()));
                    RewardAdFormat.this.retryLoadReward(ad_index, retry_count, listener);
                }

                public void onAdClicked(Placement placement, AdInfo adInfo) {
                }

                public void onAdRewarded(Placement placement, AdInfo adInfo) {
                    listener.onComplete();
                    Log.d((String)TAG, (String)(type.name() + " rewarded onComplete"));
                }

                public void onAdClosed(AdInfo adInfo) {
                    Log.d((String)TAG, (String)(type.name() + " rewarded onDismissed"));
                    RewardAdFormat.this.retryLoadReward(ad_index, retry_count, listener);
                    listener.onDismissed();
                }
            });
        } else {
            listener.onComplete();
        }
    }

    public boolean showRewardAd(AdRewardedListener listener) {
        AdNetworkType type = AdConfig.ad_networks[last_reward_index];
        if (type == AdNetworkType.ADMOB || type == AdNetworkType.FAN_BIDDING_ADMOB) {
            if (this.adMobRewardedAd != null) {
                this.adMobRewardedAd.show(this.activity, rewardItem -> {
                    listener.onComplete();
                    Log.d((String)TAG, (String)((Object)((Object)type) + " The user earned the reward."));
                });
            } else {
                listener.onError();
            }
        } else if (type == AdNetworkType.MANAGER || type == AdNetworkType.FAN_BIDDING_AD_MANAGER) {
            if (this.adManagerRewardedAd != null) {
                this.adManagerRewardedAd.show(this.activity, rewardItem -> {
                    listener.onComplete();
                    Log.d((String)TAG, (String)((Object)((Object)type) + " The user earned the reward."));
                });
            } else {
                listener.onError();
            }
        } else if (type == AdNetworkType.FAN) {
            if (this.fanRewardedVideoAd != null && this.fanRewardedVideoAd.isAdLoaded()) {
                this.fanRewardedVideoAd.show();
            } else {
                listener.onError();
            }
        } else if (type == AdNetworkType.IRONSOURCE || type == AdNetworkType.FAN_BIDDING_IRONSOURCE) {
            if (IronSource.isRewardedVideoAvailable()) {
                IronSource.showRewardedVideo((String)AdConfig.ad_ironsource_rewarded_unit_id);
            } else {
                listener.onError();
            }
        } else {
            listener.onError();
        }
        return true;
    }

    private void retryLoadReward(int ad_index, int retry_count, AdRewardedListener listener) {
        int adIndex = ad_index + 1;
        int finalRetry = retry_count;
        if (adIndex > AdConfig.ad_networks.length - 1) {
            adIndex = 0;
            ++finalRetry;
        }
        Log.d((String)TAG, (String)("delayAndLoadReward ad_index : " + ad_index + " retry_count : " + retry_count));
        int _adIndex = adIndex;
        int _finalRetry = finalRetry;
        new Handler(this.activity.getMainLooper()).postDelayed(() -> this.loadRewardAd(_adIndex, _finalRetry, listener), 1000L);
    }
}

