/*
 * Decompiled with CFR 0.152.
 */
package dreamspace.ads.sdk.format;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.util.Log;
import androidx.annotation.NonNull;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.InterstitialAd;
import com.facebook.ads.InterstitialAdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.admanager.AdManagerAdRequest;
import com.google.android.gms.ads.admanager.AdManagerInterstitialAd;
import com.google.android.gms.ads.admanager.AdManagerInterstitialAdLoadCallback;
import com.google.android.gms.ads.interstitial.InterstitialAdLoadCallback;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.adunit.adapter.utility.AdInfo;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.sdk.LevelPlayInterstitialListener;
import dreamspace.ads.sdk.AdConfig;
import dreamspace.ads.sdk.AdNetwork;
import dreamspace.ads.sdk.data.AdNetworkType;
import dreamspace.ads.sdk.data.SharedPref;
import dreamspace.ads.sdk.listener.AdIntersListener;
import dreamspace.ads.sdk.utils.Tools;

public class InterstitialAdFormat {
    private static final String TAG = AdNetwork.class.getSimpleName();
    private com.google.android.gms.ads.interstitial.InterstitialAd adMobInterstitialAd;
    private AdManagerInterstitialAd adManagerInterstitialAd;
    private InterstitialAd fanInterstitialAd;
    private static int last_interstitial_index = 0;
    private final Activity activity;
    private final SharedPref sharedPref;
    private AdIntersListener listener;
    private int retryAttempt;
    private int counter = 1;

    public InterstitialAdFormat(Activity activity) {
        this.activity = activity;
        this.sharedPref = new SharedPref((Context)activity);
    }

    public void loadInterstitialAd(final int ad_index, final int retry_count) {
        if (retry_count > AdConfig.retry_from_start_max) {
            return;
        }
        last_interstitial_index = ad_index;
        final AdNetworkType type = AdConfig.ad_networks[ad_index];
        if (type == AdNetworkType.ADMOB || type == AdNetworkType.FAN_BIDDING_ADMOB) {
            com.google.android.gms.ads.interstitial.InterstitialAd.load((Context)this.activity, (String)AdConfig.ad_admob_interstitial_unit_id, (AdRequest)new AdRequest.Builder().build(), (InterstitialAdLoadCallback)new InterstitialAdLoadCallback(){

                public void onAdLoaded(@NonNull com.google.android.gms.ads.interstitial.InterstitialAd interstitialAd) {
                    InterstitialAdFormat.this.adMobInterstitialAd = interstitialAd;
                    Log.d((String)TAG, (String)(type.name() + " interstitial onAdLoaded"));
                    InterstitialAdFormat.this.adMobInterstitialAd.setFullScreenContentCallback(new FullScreenContentCallback(){

                        public void onAdShowedFullScreenContent() {
                            super.onAdShowedFullScreenContent();
                            InterstitialAdFormat.this.sharedPref.setIntersCounter(0);
                            InterstitialAdFormat.this.loadInterstitialAd(0, 0);
                        }

                        public void onAdDismissedFullScreenContent() {
                            super.onAdDismissedFullScreenContent();
                            InterstitialAdFormat.this.adMobInterstitialAd = null;
                        }
                    });
                }

                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                    InterstitialAdFormat.this.adMobInterstitialAd = null;
                    Log.d((String)TAG, (String)(type.name() + " interstitial onAdFailedToLoad"));
                    InterstitialAdFormat.this.retryLoadInterstitial(ad_index, retry_count);
                }
            });
        } else if (type == AdNetworkType.MANAGER || type == AdNetworkType.FAN_BIDDING_AD_MANAGER) {
            AdManagerInterstitialAd.load((Context)this.activity, (String)AdConfig.ad_manager_interstitial_unit_id, (AdManagerAdRequest)Tools.getGoogleAdManagerRequest(), (AdManagerInterstitialAdLoadCallback)new AdManagerInterstitialAdLoadCallback(){

                public void onAdLoaded(@NonNull AdManagerInterstitialAd interstitialAd) {
                    super.onAdLoaded((Object)InterstitialAdFormat.this.adManagerInterstitialAd);
                    InterstitialAdFormat.this.adManagerInterstitialAd = interstitialAd;
                    Log.d((String)TAG, (String)(type.name() + " interstitial onAdLoaded"));
                    InterstitialAdFormat.this.adManagerInterstitialAd.setFullScreenContentCallback(new FullScreenContentCallback(){

                        public void onAdShowedFullScreenContent() {
                            super.onAdShowedFullScreenContent();
                            InterstitialAdFormat.this.sharedPref.setIntersCounter(0);
                            InterstitialAdFormat.this.loadInterstitialAd(0, 0);
                        }

                        public void onAdDismissedFullScreenContent() {
                            super.onAdDismissedFullScreenContent();
                            InterstitialAdFormat.this.adManagerInterstitialAd = null;
                        }
                    });
                }

                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                    super.onAdFailedToLoad(loadAdError);
                    InterstitialAdFormat.this.adManagerInterstitialAd = null;
                    Log.d((String)TAG, (String)(type.name() + " interstitial onAdFailedToLoad"));
                    InterstitialAdFormat.this.retryLoadInterstitial(ad_index, retry_count);
                }
            });
        } else if (type == AdNetworkType.FAN) {
            this.fanInterstitialAd = new InterstitialAd((Context)this.activity, AdConfig.ad_fan_interstitial_unit_id);
            InterstitialAdListener interstitialAdListener = new InterstitialAdListener(){

                public void onInterstitialDisplayed(Ad ad) {
                }

                public void onInterstitialDismissed(Ad ad) {
                    InterstitialAdFormat.this.sharedPref.setIntersCounter(0);
                    InterstitialAdFormat.this.loadInterstitialAd(0, 0);
                }

                public void onError(Ad ad, AdError adError) {
                    InterstitialAdFormat.this.adMobInterstitialAd = null;
                    Log.d((String)TAG, (String)(type.name() + " interstitial onError"));
                    InterstitialAdFormat.this.retryLoadInterstitial(ad_index, retry_count);
                }

                public void onAdLoaded(Ad ad) {
                    Log.d((String)TAG, (String)"FAN interstitial onAdLoaded");
                }

                public void onAdClicked(Ad ad) {
                }

                public void onLoggingImpression(Ad ad) {
                }
            };
            this.fanInterstitialAd.loadAd(this.fanInterstitialAd.buildLoadAdConfig().withAdListener(interstitialAdListener).build());
        } else if (type == AdNetworkType.IRONSOURCE || type == AdNetworkType.FAN_BIDDING_IRONSOURCE) {
            IronSource.setLevelPlayInterstitialListener((LevelPlayInterstitialListener)new LevelPlayInterstitialListener(){

                public void onAdReady(AdInfo adInfo) {
                    Log.d((String)TAG, (String)(type.name() + " interstitial onInterstitialAdReady"));
                }

                public void onAdLoadFailed(IronSourceError ironSourceError) {
                    Log.d((String)TAG, (String)(type.name() + " interstitial onAdLoadFailed : " + ironSourceError.getErrorMessage()));
                    InterstitialAdFormat.this.retryLoadInterstitial(ad_index, retry_count);
                }

                public void onAdOpened(AdInfo adInfo) {
                }

                public void onAdShowSucceeded(AdInfo adInfo) {
                }

                public void onAdShowFailed(IronSourceError ironSourceError, AdInfo adInfo) {
                }

                public void onAdClicked(AdInfo adInfo) {
                }

                public void onAdClosed(AdInfo adInfo) {
                    InterstitialAdFormat.this.sharedPref.setIntersCounter(0);
                    InterstitialAdFormat.this.loadInterstitialAd(0, 0);
                }
            });
            IronSource.loadInterstitial();
        }
    }

    public boolean showInterstitialAd() {
        int counter = this.sharedPref.getIntersCounter();
        Log.d((String)TAG, (String)("COUNTER " + counter));
        if (counter <= AdConfig.ad_inters_interval) {
            Log.d((String)TAG, (String)("COUNTER not-reach attempt : " + counter));
            this.sharedPref.setIntersCounter(this.sharedPref.getIntersCounter() + 1);
            return false;
        }
        Log.d((String)TAG, (String)"COUNTER reach attempt");
        int ad_index = last_interstitial_index;
        AdNetworkType type = AdConfig.ad_networks[ad_index];
        if (type == AdNetworkType.ADMOB || type == AdNetworkType.FAN_BIDDING_ADMOB) {
            if (this.adMobInterstitialAd == null) {
                this.loadInterstitialAd(0, 0);
                return false;
            }
            this.adMobInterstitialAd.show(this.activity);
        } else if (type == AdNetworkType.MANAGER || type == AdNetworkType.FAN_BIDDING_AD_MANAGER) {
            if (this.adManagerInterstitialAd == null) {
                this.loadInterstitialAd(0, 0);
                return false;
            }
            this.adManagerInterstitialAd.show(this.activity);
        } else if (type == AdNetworkType.FAN) {
            if (this.fanInterstitialAd == null || !this.fanInterstitialAd.isAdLoaded()) {
                this.loadInterstitialAd(0, 0);
                return false;
            }
            this.fanInterstitialAd.show();
        } else if (type == AdNetworkType.IRONSOURCE || type == AdNetworkType.FAN_BIDDING_IRONSOURCE) {
            if (IronSource.isInterstitialReady()) {
                IronSource.showInterstitial((String)AdConfig.ad_ironsource_interstitial_unit_id);
            } else {
                this.loadInterstitialAd(0, 0);
                return false;
            }
        }
        return true;
    }

    public void setListener(AdIntersListener listener) {
        this.listener = listener;
    }

    private void retryLoadInterstitial(int ad_index, int retry_count) {
        int adIndex = ad_index + 1;
        int finalRetry = retry_count;
        if (adIndex > AdConfig.ad_networks.length - 1) {
            adIndex = 0;
            ++finalRetry;
        }
        Log.d((String)TAG, (String)("delayAndLoadInterstitial ad_index : " + ad_index + " retry_count : " + retry_count));
        int _adIndex = adIndex;
        int _finalRetry = finalRetry;
        new Handler(this.activity.getMainLooper()).postDelayed(() -> this.loadInterstitialAd(_adIndex, _finalRetry), 3000L);
    }
}

