/*
 * Decompiled with CFR 0.152.
 */
package dreamspace.ads.sdk.format;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdListener;
import com.facebook.ads.AdSize;
import com.facebook.ads.AdView;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.admanager.AdManagerAdView;
import com.ironsource.mediationsdk.ISBannerSize;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.adunit.adapter.utility.AdInfo;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.sdk.LevelPlayBannerListener;
import dreamspace.ads.sdk.AdConfig;
import dreamspace.ads.sdk.AdNetwork;
import dreamspace.ads.sdk.data.AdNetworkType;
import dreamspace.ads.sdk.utils.Tools;
import java.util.List;

public class BannerAdFormat {
    private static final String TAG = AdNetwork.class.getSimpleName();
    private final Activity activity;
    private LinearLayout adContainer;
    private IronSourceBannerLayout ironSourceBannerLayout;

    public BannerAdFormat(Activity activity) {
        this.activity = activity;
    }

    public void loadBannerAdMain(final int ad_index, final int retry_count, final LinearLayout ad_container) {
        if (retry_count > AdConfig.retry_from_start_max) {
            return;
        }
        ad_container.setVisibility(8);
        ad_container.removeAllViews();
        final AdNetworkType type = AdConfig.ad_networks[ad_index];
        ad_container.post(() -> {
            if (type == AdNetworkType.ADMOB || type == AdNetworkType.FAN_BIDDING_ADMOB) {
                AdView adView = new AdView((Context)this.activity);
                adView.setAdUnitId(AdConfig.ad_admob_banner_unit_id);
                ad_container.addView((View)adView);
                adView.setAdSize(Tools.getAdSize(this.activity));
                adView.loadAd(Tools.getAdRequest(this.activity));
                adView.setAdListener(new com.google.android.gms.ads.AdListener(){

                    public void onAdLoaded() {
                        ad_container.setVisibility(0);
                        Log.d((String)TAG, (String)(type.name() + " banner onAdLoaded"));
                    }

                    public void onAdFailedToLoad(@NonNull LoadAdError adError) {
                        ad_container.setVisibility(8);
                        Log.d((String)TAG, (String)(type.name() + " banner onAdFailedToLoad : " + adError.getMessage()));
                        BannerAdFormat.this.retryLoadBanner(ad_index, retry_count, ad_container);
                    }
                });
            } else if (type == AdNetworkType.MANAGER || type == AdNetworkType.FAN_BIDDING_AD_MANAGER) {
                AdManagerAdView adView = new AdManagerAdView((Context)this.activity);
                adView.setAdUnitId(AdConfig.ad_manager_banner_unit_id);
                ad_container.addView((View)adView);
                adView.setAdSize(Tools.getAdSize(this.activity));
                adView.loadAd(Tools.getGoogleAdManagerRequest());
                adView.setAdListener(new com.google.android.gms.ads.AdListener(){

                    public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                        super.onAdFailedToLoad(loadAdError);
                        Log.d((String)TAG, (String)(type.name() + " banner onAdFailedToLoad : " + loadAdError.getMessage()));
                        BannerAdFormat.this.retryLoadBanner(ad_index, retry_count, ad_container);
                    }

                    public void onAdLoaded() {
                        super.onAdLoaded();
                        Log.d((String)TAG, (String)"MANAGER onAdLoaded");
                        ad_container.setVisibility(0);
                    }
                });
            } else if (type == AdNetworkType.FAN) {
                com.facebook.ads.AdView adView = new com.facebook.ads.AdView((Context)this.activity, AdConfig.ad_fan_banner_unit_id, AdSize.BANNER_HEIGHT_50);
                ad_container.addView((View)adView);
                AdListener adListener = new AdListener(){

                    public void onError(Ad ad, AdError adError) {
                        ad_container.setVisibility(8);
                        Log.d((String)TAG, (String)(type.name() + " banner onAdFailedToLoad : " + adError.getErrorMessage()));
                        BannerAdFormat.this.retryLoadBanner(ad_index, retry_count, ad_container);
                    }

                    public void onAdLoaded(Ad ad) {
                        ad_container.setVisibility(0);
                        Log.d((String)TAG, (String)(type.name() + " banner onAdLoaded"));
                    }

                    public void onAdClicked(Ad ad) {
                    }

                    public void onLoggingImpression(Ad ad) {
                    }
                };
                AdView.AdViewLoadConfig loadAdConfig = adView.buildLoadAdConfig().withAdListener(adListener).build();
                adView.loadAd(loadAdConfig);
            } else if (type == AdNetworkType.IRONSOURCE || type == AdNetworkType.FAN_BIDDING_IRONSOURCE) {
                IronSource.init((Context)this.activity, (String)AdConfig.ad_ironsource_app_key, (IronSource.AD_UNIT[])new IronSource.AD_UNIT[]{IronSource.AD_UNIT.BANNER, IronSource.AD_UNIT.INTERSTITIAL});
                ISBannerSize bannerSize = ISBannerSize.BANNER;
                bannerSize.setAdaptive(true);
                this.ironSourceBannerLayout = IronSource.createBanner((Activity)this.activity, (ISBannerSize)bannerSize);
                FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -2);
                ad_container.addView((View)this.ironSourceBannerLayout, 0, (ViewGroup.LayoutParams)layoutParams);
                this.ironSourceBannerLayout.setLevelPlayBannerListener(new LevelPlayBannerListener(){

                    public void onAdLoaded(AdInfo adInfo) {
                        ad_container.setVisibility(0);
                        Log.d((String)TAG, (String)(type.name() + " banner onBannerAdLoaded"));
                    }

                    public void onAdLoadFailed(IronSourceError ironSourceError) {
                        ad_container.setVisibility(8);
                        Log.d((String)TAG, (String)(type.name() + " banner onBannerAdLoadFailed : " + ironSourceError.getErrorMessage()));
                        BannerAdFormat.this.retryLoadBanner(ad_index, retry_count, ad_container);
                    }

                    public void onAdClicked(AdInfo adInfo) {
                    }

                    public void onAdLeftApplication(AdInfo adInfo) {
                    }

                    public void onAdScreenPresented(AdInfo adInfo) {
                    }

                    public void onAdScreenDismissed(AdInfo adInfo) {
                    }
                });
                IronSource.loadBanner((IronSourceBannerLayout)this.ironSourceBannerLayout, (String)AdConfig.ad_ironsource_banner_unit_id);
            }
        });
        this.adContainer = ad_container;
    }

    private void retryLoadBanner(int ad_index, int retry_count, LinearLayout ad_container) {
        int adIndex = ad_index + 1;
        int finalRetry = retry_count;
        if (adIndex > AdConfig.ad_networks.length - 1) {
            adIndex = 0;
            ++finalRetry;
        }
        int _adIndex = adIndex;
        int _finalRetry = finalRetry;
        Log.d((String)TAG, (String)("delayAndLoadBanner ad_index : " + _adIndex + " retry_count : " + _finalRetry));
        new Handler(this.activity.getMainLooper()).postDelayed(() -> this.loadBannerAdMain(_adIndex, _finalRetry, ad_container), 3000L);
    }

    public void destroyAndDetachBanner(List<AdNetworkType> adNetworks) {
        if (Tools.contains(adNetworks, AdNetworkType.IRONSOURCE, AdNetworkType.FAN_BIDDING_IRONSOURCE)) {
            if (this.ironSourceBannerLayout != null) {
                Log.d((String)TAG, (String)"ironSource banner is not null, ready to destroy");
                IronSource.destroyBanner((IronSourceBannerLayout)this.ironSourceBannerLayout);
                this.adContainer.removeView((View)this.ironSourceBannerLayout);
            } else {
                Log.d((String)TAG, (String)"ironSource banner is null");
            }
        }
    }
}

