/*
 * Decompiled with CFR 0.152.
 */
package dreamspace.ads.sdk;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import android.widget.LinearLayout;
import com.facebook.ads.AdSettings;
import com.facebook.ads.AudienceNetworkAds;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.initialization.AdapterStatus;
import com.ironsource.mediationsdk.IronSource;
import dreamspace.ads.sdk.AdConfig;
import dreamspace.ads.sdk.data.AdNetworkType;
import dreamspace.ads.sdk.data.SharedPref;
import dreamspace.ads.sdk.format.BannerAdFormat;
import dreamspace.ads.sdk.format.InterstitialAdFormat;
import dreamspace.ads.sdk.format.OpenAppAdFormat;
import dreamspace.ads.sdk.format.RewardAdFormat;
import dreamspace.ads.sdk.gdpr.UMP;
import dreamspace.ads.sdk.helper.AudienceNetworkInitializeHelper;
import dreamspace.ads.sdk.listener.AdOpenListener;
import dreamspace.ads.sdk.listener.AdRewardedListener;
import dreamspace.ads.sdk.utils.Tools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class AdNetwork {
    private static final String TAG = AdNetwork.class.getSimpleName();
    private final Activity activity;
    private final SharedPref sharedPref;
    private static BannerAdFormat bannerAdFormat;
    private static InterstitialAdFormat interstitialAdFormat;
    private static RewardAdFormat rewardAdFormat;
    private static OpenAppAdFormat openAppAdFormat;
    public static String GAID;
    private static List<AdNetworkType> ad_networks;

    public AdNetwork(Activity activity) {
        this.activity = activity;
        this.sharedPref = new SharedPref((Context)activity);
        if (AdConfig.ad_enable_banner) {
            bannerAdFormat = new BannerAdFormat(activity);
        }
        if (AdConfig.ad_enable_interstitial) {
            interstitialAdFormat = new InterstitialAdFormat(activity);
        }
        if (AdConfig.ad_enable_rewarded) {
            rewardAdFormat = new RewardAdFormat(activity);
        }
        if (AdConfig.ad_enable_open_app) {
            openAppAdFormat = new OpenAppAdFormat(activity);
        }
        Tools.getGAID((Context)activity);
    }

    public void init() {
        if (!AdConfig.ad_enable) {
            return;
        }
        if (AdConfig.ad_networks.length == 0) {
            AdConfig.ad_networks = new AdNetworkType[]{AdConfig.ad_network};
        }
        ad_networks = Arrays.asList(AdConfig.ad_networks);
        if (Tools.contains(ad_networks, AdNetworkType.ADMOB, AdNetworkType.MANAGER, AdNetworkType.FAN_BIDDING_ADMOB, AdNetworkType.FAN_BIDDING_AD_MANAGER)) {
            Log.d((String)TAG, (String)"ADMOB, MANAGER, FAN_BIDDING_ADMOB, FAN_BIDDING_AD_MANAGER init");
            MobileAds.initialize((Context)this.activity);
            MobileAds.initialize((Context)this.activity, initializationStatus -> {
                Map statusMap = initializationStatus.getAdapterStatusMap();
                for (String adapterClass : statusMap.keySet()) {
                    AdapterStatus adapterStatus = (AdapterStatus)statusMap.get(adapterClass);
                    assert (adapterStatus != null);
                    Log.d((String)TAG, (String)String.format("Adapter name: %s, Description: %s, Latency: %d", adapterClass, adapterStatus.getDescription(), adapterStatus.getLatency()));
                }
            });
            AudienceNetworkInitializeHelper.initializeAd((Context)this.activity, AdConfig.debug_mode);
        }
        if (Tools.contains(ad_networks, AdNetworkType.FAN)) {
            Log.d((String)TAG, (String)"FAN init");
            AudienceNetworkAds.initialize((Context)this.activity);
            AdSettings.setIntegrationErrorMode((AdSettings.IntegrationErrorMode)AdSettings.IntegrationErrorMode.INTEGRATION_ERROR_CALLBACK_MODE);
            if (AdConfig.debug_mode) {
                AdSettings.turnOnSDKDebugger((Context)this.activity);
                AdSettings.setTestMode((boolean)true);
            }
        }
        if (Tools.contains(ad_networks, AdNetworkType.IRONSOURCE, AdNetworkType.FAN_BIDDING_IRONSOURCE)) {
            Log.d((String)TAG, (String)"IRONSOURCE init");
            String advertisingId = IronSource.getAdvertiserId((Context)this.activity);
            IronSource.setUserId((String)advertisingId);
            IronSource.init((Context)this.activity, (String)AdConfig.ad_ironsource_app_key, () -> Log.d((String)TAG, (String)"IRONSOURCE onInitializationComplete"));
        }
        this.sharedPref.setOpenAppUnitId(AdConfig.ad_admob_open_app_unit_id);
    }

    public void loadBannerAd(boolean enable, LinearLayout ad_container) {
        if (!AdConfig.ad_enable || bannerAdFormat == null || !enable) {
            return;
        }
        bannerAdFormat.loadBannerAdMain(0, 0, ad_container);
    }

    public void loadInterstitialAd(boolean enable) {
        if (!AdConfig.ad_enable || interstitialAdFormat == null || !enable) {
            return;
        }
        interstitialAdFormat.loadInterstitialAd(0, 0);
    }

    public boolean showInterstitialAd(boolean enable) {
        if (!AdConfig.ad_enable || interstitialAdFormat == null || !enable) {
            return false;
        }
        return interstitialAdFormat.showInterstitialAd();
    }

    public void loadRewardedAd(boolean enable, AdRewardedListener listener) {
        if (!AdConfig.ad_enable || rewardAdFormat == null || !enable) {
            return;
        }
        rewardAdFormat.loadRewardAd(0, 0, listener);
    }

    public boolean showRewardedAd(boolean enable, AdRewardedListener listener) {
        if (!AdConfig.ad_enable || rewardAdFormat == null || !enable) {
            return false;
        }
        return rewardAdFormat.showRewardAd(listener);
    }

    public void loadAndShowOpenAppAd(Activity activity, boolean enable, AdOpenListener listener) {
        if (!AdConfig.ad_enable || openAppAdFormat == null || !enable) {
            if (listener != null) {
                listener.onFinish();
            }
            return;
        }
        openAppAdFormat.loadAndShowOpenAppAd(0, 0, listener);
    }

    public static void loadOpenAppAd(Context context, boolean enable) {
        if (!AdConfig.ad_enable || openAppAdFormat == null || !enable) {
            return;
        }
        OpenAppAdFormat.loadOpenAppAd(context, 0, 0);
    }

    public static void showOpenAppAd(Context context, boolean enable) {
        if (!AdConfig.ad_enable || openAppAdFormat == null || !enable) {
            return;
        }
        OpenAppAdFormat.showOpenAppAd(context);
    }

    public void destroyAndDetachBanner() {
        if (bannerAdFormat == null) {
            return;
        }
        bannerAdFormat.destroyAndDetachBanner(ad_networks);
    }

    public void loadShowUMPConsentForm() {
        new UMP(this.activity).loadShowConsentForm();
    }

    static {
        GAID = "";
        ad_networks = new ArrayList<AdNetworkType>();
    }
}

