/*
 * Decompiled with CFR 0.152.
 */
package com.tsongkha.spinnerdatepicker;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.format.DateFormat;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.NumberPicker;
import com.tsongkha.spinnerdatepicker.ICU;
import com.tsongkha.spinnerdatepicker.NumberPickers;
import com.tsongkha.spinnerdatepicker.OnDateChangedListener;
import com.tsongkha.spinnerdatepicker.R;
import com.tsongkha.spinnerdatepicker.TwoDigitFormatter;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;

public class DatePicker
extends FrameLayout {
    private static final String DATE_FORMAT = "MM/dd/yyyy";
    private static final boolean DEFAULT_ENABLED_STATE = true;
    private LinearLayout mPickerContainer;
    private NumberPicker mDaySpinner;
    private NumberPicker mMonthSpinner;
    private NumberPicker mYearSpinner;
    private EditText mDaySpinnerInput;
    private EditText mMonthSpinnerInput;
    private EditText mYearSpinnerInput;
    private Context mContext;
    private OnDateChangedListener mOnDateChangedListener;
    private String[] mShortMonths;
    private final java.text.DateFormat mDateFormat = new SimpleDateFormat("MM/dd/yyyy");
    private int mNumberOfMonths;
    private Calendar mTempDate;
    private Calendar mMinDate;
    private Calendar mMaxDate;
    private Calendar mCurrentDate;
    private boolean mIsEnabled = true;

    DatePicker(ViewGroup root, int numberPickerStyle) {
        super(root.getContext());
        this.mContext = root.getContext();
        this.setCurrentLocale(Locale.getDefault());
        LayoutInflater inflater = (LayoutInflater)new ContextThemeWrapper(this.mContext, numberPickerStyle).getSystemService("layout_inflater");
        inflater.inflate(R.layout.date_picker_container, (ViewGroup)this, true);
        this.mPickerContainer = (LinearLayout)this.findViewById(R.id.parent);
        NumberPicker.OnValueChangeListener onChangeListener = new NumberPicker.OnValueChangeListener(){

            public void onValueChange(NumberPicker picker, int oldVal, int newVal) {
                DatePicker.this.updateInputState();
                DatePicker.this.mTempDate.setTimeInMillis(DatePicker.this.mCurrentDate.getTimeInMillis());
                if (picker == DatePicker.this.mDaySpinner) {
                    int maxDayOfMonth = DatePicker.this.mTempDate.getActualMaximum(5);
                    if (oldVal == maxDayOfMonth && newVal == 1) {
                        DatePicker.this.mTempDate.add(5, 1);
                    } else if (oldVal == 1 && newVal == maxDayOfMonth) {
                        DatePicker.this.mTempDate.add(5, -1);
                    } else {
                        DatePicker.this.mTempDate.add(5, newVal - oldVal);
                    }
                } else if (picker == DatePicker.this.mMonthSpinner) {
                    if (oldVal == 11 && newVal == 0) {
                        DatePicker.this.mTempDate.add(2, 1);
                    } else if (oldVal == 0 && newVal == 11) {
                        DatePicker.this.mTempDate.add(2, -1);
                    } else {
                        DatePicker.this.mTempDate.add(2, newVal - oldVal);
                    }
                } else if (picker == DatePicker.this.mYearSpinner) {
                    DatePicker.this.mTempDate.set(1, newVal);
                } else {
                    throw new IllegalArgumentException();
                }
                DatePicker.this.setDate(DatePicker.this.mTempDate.get(1), DatePicker.this.mTempDate.get(2), DatePicker.this.mTempDate.get(5));
                DatePicker.this.updateSpinners();
                DatePicker.this.notifyDateChanged();
            }
        };
        this.mDaySpinner = (NumberPicker)inflater.inflate(R.layout.number_picker_day_month, (ViewGroup)this.mPickerContainer, false);
        this.mDaySpinner.setId(R.id.day);
        this.mDaySpinner.setFormatter((NumberPicker.Formatter)new TwoDigitFormatter());
        this.mDaySpinner.setOnLongPressUpdateInterval(100L);
        this.mDaySpinner.setOnValueChangedListener(onChangeListener);
        this.mDaySpinnerInput = NumberPickers.findEditText(this.mDaySpinner);
        this.mMonthSpinner = (NumberPicker)inflater.inflate(R.layout.number_picker_day_month, (ViewGroup)this.mPickerContainer, false);
        this.mMonthSpinner.setId(R.id.month);
        this.mMonthSpinner.setMinValue(0);
        this.mMonthSpinner.setMaxValue(this.mNumberOfMonths - 1);
        this.mMonthSpinner.setDisplayedValues(this.mShortMonths);
        this.mMonthSpinner.setOnLongPressUpdateInterval(200L);
        this.mMonthSpinner.setOnValueChangedListener(onChangeListener);
        this.mMonthSpinnerInput = NumberPickers.findEditText(this.mMonthSpinner);
        this.mYearSpinner = (NumberPicker)inflater.inflate(R.layout.number_picker_year, (ViewGroup)this.mPickerContainer, false);
        this.mYearSpinner.setId(R.id.year);
        this.mYearSpinner.setOnLongPressUpdateInterval(100L);
        this.mYearSpinner.setOnValueChangedListener(onChangeListener);
        this.mYearSpinnerInput = NumberPickers.findEditText(this.mYearSpinner);
        this.mCurrentDate.setTimeInMillis(System.currentTimeMillis());
        this.reorderSpinners();
        if (this.getImportantForAccessibility() == 0) {
            this.setImportantForAccessibility(1);
        }
        root.addView((View)this);
    }

    void init(int year, int monthOfYear, int dayOfMonth, OnDateChangedListener onDateChangedListener) {
        this.setDate(year, monthOfYear, dayOfMonth);
        this.updateSpinners();
        this.mOnDateChangedListener = onDateChangedListener;
        this.notifyDateChanged();
    }

    void updateDate(int year, int month, int dayOfMonth) {
        if (!this.isNewDate(year, month, dayOfMonth)) {
            return;
        }
        this.setDate(year, month, dayOfMonth);
        this.updateSpinners();
        this.notifyDateChanged();
    }

    int getYear() {
        return this.mCurrentDate.get(1);
    }

    int getMonth() {
        return this.mCurrentDate.get(2);
    }

    int getDayOfMonth() {
        return this.mCurrentDate.get(5);
    }

    void setMinDate(long minDate) {
        this.mTempDate.setTimeInMillis(minDate);
        if (this.mTempDate.get(1) == this.mMinDate.get(1) && this.mTempDate.get(6) == this.mMinDate.get(6)) {
            return;
        }
        this.mMinDate.setTimeInMillis(minDate);
        if (this.mCurrentDate.before(this.mMinDate)) {
            this.mCurrentDate.setTimeInMillis(this.mMinDate.getTimeInMillis());
        }
        this.updateSpinners();
    }

    void setMaxDate(long maxDate) {
        this.mTempDate.setTimeInMillis(maxDate);
        if (this.mTempDate.get(1) == this.mMaxDate.get(1) && this.mTempDate.get(6) == this.mMaxDate.get(6)) {
            return;
        }
        this.mMaxDate.setTimeInMillis(maxDate);
        if (this.mCurrentDate.after(this.mMaxDate)) {
            this.mCurrentDate.setTimeInMillis(this.mMaxDate.getTimeInMillis());
        }
        this.updateSpinners();
    }

    public void setEnabled(boolean enabled) {
        this.mDaySpinner.setEnabled(enabled);
        this.mMonthSpinner.setEnabled(enabled);
        this.mYearSpinner.setEnabled(enabled);
        this.mIsEnabled = enabled;
    }

    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        this.setCurrentLocale(newConfig.locale);
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        this.onPopulateAccessibilityEvent(event);
        return true;
    }

    protected void setCurrentLocale(Locale locale) {
        this.mTempDate = this.getCalendarForLocale(this.mTempDate, locale);
        this.mMinDate = this.getCalendarForLocale(this.mMinDate, locale);
        this.mMaxDate = this.getCalendarForLocale(this.mMaxDate, locale);
        this.mCurrentDate = this.getCalendarForLocale(this.mCurrentDate, locale);
        this.mNumberOfMonths = this.mTempDate.getActualMaximum(2) + 1;
        this.mShortMonths = new DateFormatSymbols().getShortMonths();
        if (this.usingNumericMonths()) {
            this.mShortMonths = new String[this.mNumberOfMonths];
            for (int i = 0; i < this.mNumberOfMonths; ++i) {
                this.mShortMonths[i] = String.format("%d", i + 1);
            }
        }
    }

    private boolean usingNumericMonths() {
        return Character.isDigit(this.mShortMonths[0].charAt(0));
    }

    private Calendar getCalendarForLocale(Calendar oldCalendar, Locale locale) {
        if (oldCalendar == null) {
            return Calendar.getInstance(locale);
        }
        long currentTimeMillis = oldCalendar.getTimeInMillis();
        Calendar newCalendar = Calendar.getInstance(locale);
        newCalendar.setTimeInMillis(currentTimeMillis);
        return newCalendar;
    }

    private void reorderSpinners() {
        this.mPickerContainer.removeAllViews();
        String pattern = null;
        pattern = Build.VERSION.SDK_INT < 18 ? this.getOrderJellyBeanMr2() : DateFormat.getBestDateTimePattern((Locale)Locale.getDefault(), (String)"yyyyMMMdd");
        char[] order = ICU.getDateFormatOrder(pattern);
        int spinnerCount = order.length;
        block5: for (int i = 0; i < spinnerCount; ++i) {
            switch (order[i]) {
                case 'd': {
                    this.mPickerContainer.addView((View)this.mDaySpinner);
                    this.setImeOptions(this.mDaySpinner, spinnerCount, i);
                    continue block5;
                }
                case 'M': {
                    this.mPickerContainer.addView((View)this.mMonthSpinner);
                    this.setImeOptions(this.mMonthSpinner, spinnerCount, i);
                    continue block5;
                }
                case 'y': {
                    this.mPickerContainer.addView((View)this.mYearSpinner);
                    this.setImeOptions(this.mYearSpinner, spinnerCount, i);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException(Arrays.toString(order));
                }
            }
        }
    }

    private String getOrderJellyBeanMr2() {
        java.text.DateFormat format = this.mShortMonths[0].startsWith("1") ? DateFormat.getDateFormat((Context)this.getContext()) : DateFormat.getMediumDateFormat((Context)this.getContext());
        String order = format instanceof SimpleDateFormat ? ((SimpleDateFormat)format).toPattern() : new String(DateFormat.getDateFormatOrder((Context)this.getContext()));
        return order;
    }

    private boolean isNewDate(int year, int month, int dayOfMonth) {
        return this.mCurrentDate.get(1) != year || this.mCurrentDate.get(2) != month || this.mCurrentDate.get(5) != dayOfMonth;
    }

    private void setDate(int year, int month, int dayOfMonth) {
        this.mCurrentDate.set(year, month, dayOfMonth);
        if (this.mCurrentDate.before(this.mMinDate)) {
            this.mCurrentDate.setTimeInMillis(this.mMinDate.getTimeInMillis());
        } else if (this.mCurrentDate.after(this.mMaxDate)) {
            this.mCurrentDate.setTimeInMillis(this.mMaxDate.getTimeInMillis());
        }
    }

    private void updateSpinners() {
        if (this.mCurrentDate.equals(this.mMinDate)) {
            this.mDaySpinner.setMinValue(this.mCurrentDate.get(5));
            this.mDaySpinner.setMaxValue(this.mCurrentDate.getActualMaximum(5));
            this.mDaySpinner.setWrapSelectorWheel(false);
            this.mMonthSpinner.setDisplayedValues(null);
            this.mMonthSpinner.setMinValue(this.mCurrentDate.get(2));
            this.mMonthSpinner.setMaxValue(this.mCurrentDate.getActualMaximum(2));
            this.mMonthSpinner.setWrapSelectorWheel(false);
        } else if (this.mCurrentDate.equals(this.mMaxDate)) {
            this.mDaySpinner.setMinValue(this.mCurrentDate.getActualMinimum(5));
            this.mDaySpinner.setMaxValue(this.mCurrentDate.get(5));
            this.mDaySpinner.setWrapSelectorWheel(false);
            this.mMonthSpinner.setDisplayedValues(null);
            this.mMonthSpinner.setMinValue(this.mCurrentDate.getActualMinimum(2));
            this.mMonthSpinner.setMaxValue(this.mCurrentDate.get(2));
            this.mMonthSpinner.setWrapSelectorWheel(false);
        } else {
            this.mDaySpinner.setMinValue(1);
            this.mDaySpinner.setMaxValue(this.mCurrentDate.getActualMaximum(5));
            this.mDaySpinner.setWrapSelectorWheel(true);
            this.mMonthSpinner.setDisplayedValues(null);
            this.mMonthSpinner.setMinValue(0);
            this.mMonthSpinner.setMaxValue(11);
            this.mMonthSpinner.setWrapSelectorWheel(true);
        }
        String[] displayedValues = Arrays.copyOfRange(this.mShortMonths, this.mMonthSpinner.getMinValue(), this.mMonthSpinner.getMaxValue() + 1);
        this.mMonthSpinner.setDisplayedValues(displayedValues);
        this.mYearSpinner.setMinValue(this.mMinDate.get(1));
        this.mYearSpinner.setMaxValue(this.mMaxDate.get(1));
        this.mYearSpinner.setWrapSelectorWheel(false);
        this.mYearSpinner.setValue(this.mCurrentDate.get(1));
        this.mMonthSpinner.setValue(this.mCurrentDate.get(2));
        this.mDaySpinner.setValue(this.mCurrentDate.get(5));
        if (this.usingNumericMonths()) {
            this.mMonthSpinnerInput.setRawInputType(2);
        }
    }

    private void notifyDateChanged() {
        this.sendAccessibilityEvent(4);
        if (this.mOnDateChangedListener != null) {
            this.mOnDateChangedListener.onDateChanged(this, this.getYear(), this.getMonth(), this.getDayOfMonth());
        }
    }

    private void setImeOptions(NumberPicker spinner, int spinnerCount, int spinnerIndex) {
        int imeOptions = spinnerIndex < spinnerCount - 1 ? 5 : 6;
        EditText input = NumberPickers.findEditText(spinner);
        input.setImeOptions(imeOptions);
    }

    private void updateInputState() {
        InputMethodManager inputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
        if (inputMethodManager != null) {
            if (inputMethodManager.isActive((View)this.mYearSpinnerInput)) {
                this.mYearSpinnerInput.clearFocus();
                inputMethodManager.hideSoftInputFromWindow(this.getWindowToken(), 0);
            } else if (inputMethodManager.isActive((View)this.mMonthSpinnerInput)) {
                this.mMonthSpinnerInput.clearFocus();
                inputMethodManager.hideSoftInputFromWindow(this.getWindowToken(), 0);
            } else if (inputMethodManager.isActive((View)this.mDaySpinnerInput)) {
                this.mDaySpinnerInput.clearFocus();
                inputMethodManager.hideSoftInputFromWindow(this.getWindowToken(), 0);
            }
        }
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return new SavedState(superState, this.mCurrentDate, this.mMinDate, this.mMaxDate);
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mCurrentDate = Calendar.getInstance();
        this.mCurrentDate.setTimeInMillis(ss.currentDate);
        this.mMinDate = Calendar.getInstance();
        this.mMinDate.setTimeInMillis(ss.minDate);
        this.mMaxDate = Calendar.getInstance();
        this.mMaxDate.setTimeInMillis(ss.maxDate);
        this.updateSpinners();
    }

    private static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };
        final long currentDate;
        final long minDate;
        final long maxDate;

        SavedState(Parcelable superState, Calendar currentDate, Calendar minDate, Calendar maxDate) {
            super(superState);
            this.currentDate = currentDate.getTimeInMillis();
            this.minDate = minDate.getTimeInMillis();
            this.maxDate = maxDate.getTimeInMillis();
        }

        private SavedState(Parcel in) {
            super(in);
            this.currentDate = in.readLong();
            this.minDate = in.readLong();
            this.maxDate = in.readLong();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeLong(this.currentDate);
            dest.writeLong(this.minDate);
            dest.writeLong(this.maxDate);
        }
    }
}

