/*
 * Decompiled with CFR 0.152.
 */
package it.kamaladafrica.codicefiscale.utils;

import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public final class RegexUtils {
    public static final Pattern CF_ALLOWED_CHARS = Pattern.compile("[A-Z0-9]", 2);
    public static final Pattern CONSONANT_PATTERN = Pattern.compile("[B-DF-HJ-NP-TV-Z]", 2);
    public static final Pattern VOWEL_PATTERN = Pattern.compile("[AEIOU]", 2);

    public static void doWithMatchedGroups(Matcher m, Consumer<String> consumer) {
        while (m.find()) {
            consumer.accept(m.group());
        }
    }

    public static void doWithMatchedGroups(String regex, String s, Consumer<String> consumer) {
        RegexUtils.doWithMatchedGroups(Pattern.compile(regex), s, consumer);
    }

    public static void doWithMatchedGroups(Pattern pattern, String s, Consumer<String> consumer) {
        RegexUtils.doWithMatchedGroups(pattern.matcher(s), consumer);
    }

    public static String extract(Matcher m) {
        StringBuilder extracted = new StringBuilder();
        RegexUtils.doWithMatchedGroups(m, extracted::append);
        return extracted.toString();
    }

    public static String extract(String regex, String s) {
        return RegexUtils.extract(Pattern.compile(regex).matcher(s));
    }

    public static String extract(Pattern pattern, String s) {
        return RegexUtils.extract(pattern.matcher(s));
    }

    @Generated
    private RegexUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

