/*
 * Decompiled with CFR 0.152.
 */
package it.kamaladafrica.codicefiscale.utils;

import com.google.common.primitives.ImmutableIntArray;
import lombok.Generated;

public final class OmocodeUtils {
    private static final ImmutableIntArray OMOCODE_REPLACE_CHARS = ImmutableIntArray.of((int)76, (int[])new int[]{77, 78, 80, 81, 82, 83, 84, 85, 86});
    public static final ImmutableIntArray OMOCODE_INDEXES = ImmutableIntArray.of((int)14, (int[])new int[]{13, 12, 10, 9, 7, 6});

    public static char toOmocodeChar(char digit) {
        if (Character.isDigit(digit)) {
            return (char)OMOCODE_REPLACE_CHARS.get(Character.getNumericValue(digit));
        }
        return digit;
    }

    public static char toDigit(char omocodeChar) {
        int index = OMOCODE_REPLACE_CHARS.indexOf((int)omocodeChar);
        if (index != -1) {
            return Character.forDigit(index, 10);
        }
        return omocodeChar;
    }

    public static int level(String value, int[] indexes) {
        int i;
        for (i = 0; i < indexes.length && !Character.isDigit(value.charAt(indexes[i])); ++i) {
        }
        return i;
    }

    public static String normalize(String value, int[] indexes) {
        StringBuilder sb = new StringBuilder(value);
        for (int i : indexes) {
            char c = value.charAt(i);
            sb.setCharAt(i, OmocodeUtils.toDigit(c));
        }
        return sb.toString();
    }

    public static String normalize(String value) {
        return OmocodeUtils.normalize(value, OMOCODE_INDEXES.toArray());
    }

    public static int level(String value) {
        return OmocodeUtils.level(value, OMOCODE_INDEXES.toArray());
    }

    public static String apply(String value, int[] indexes) {
        StringBuilder sb = new StringBuilder(value);
        for (int i : indexes) {
            char c = value.charAt(i);
            sb.setCharAt(i, OmocodeUtils.toOmocodeChar(c));
        }
        return sb.toString();
    }

    @Generated
    private OmocodeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

