/*
 * Decompiled with CFR 0.152.
 */
package it.kamaladafrica.codicefiscale.internal;

import it.kamaladafrica.codicefiscale.internal.AbstractPart;
import it.kamaladafrica.codicefiscale.utils.PartUtils;
import lombok.Generated;
import org.apache.commons.lang3.Validate;

public final class NamePart
extends AbstractPart {
    public static final int PART_LENGTH = 3;
    public static final int INDEX_TO_REMOVE = 1;
    private static final String MISSING_LETTERS_PLACEHOLDER = "XXX";
    private static final String VALIDATION_PATTERN = "^(?:[A-Z][AEIOU][AEIOUX]|[B-DF-HJ-NP-TV-Z]{2}[A-Z])$";
    private final String name;

    public static NamePart from(String value) {
        Validate.notEmpty((CharSequence)value, (String)"invalid name: %s", (Object[])new Object[]{value});
        Validate.matchesPattern((CharSequence)value, (String)VALIDATION_PATTERN, (String)"invalid value: %s", (Object[])new Object[]{value});
        value = PartUtils.removePlaceholderIfPresent(value);
        return NamePart.of(value);
    }

    public static NamePart of(String value) {
        Validate.notEmpty((CharSequence)value, (String)"invalid name: %s", (Object[])new Object[]{value});
        Validate.validIndex((CharSequence)PartUtils.normalizeString(value), (int)1, (String)"invalid name: %s", (Object[])new Object[]{value});
        return new NamePart(value);
    }

    @Override
    protected String computeValue() {
        String name = PartUtils.normalizeString(this.getName());
        StringBuilder part = new StringBuilder();
        part.append(this.nameConsonants(name));
        part.append(PartUtils.extractVowels(name));
        part.append(MISSING_LETTERS_PLACEHOLDER);
        part.setLength(3);
        Validate.matchesPattern((CharSequence)part, (String)VALIDATION_PATTERN, (String)"unexpected result: %s", (Object[])new Object[]{part});
        return part.toString();
    }

    private String nameConsonants(String name) {
        String consonants = PartUtils.extractConsonants(name);
        if (consonants.length() > 3) {
            consonants = new StringBuilder(consonants).deleteCharAt(1).toString();
        }
        return consonants;
    }

    @Override
    protected String applyOmocodeLevel(String computeValue) {
        return computeValue;
    }

    @Override
    protected void validateValue(String value) {
        Validate.matchesPattern((CharSequence)value, (String)VALIDATION_PATTERN, (String)"unexpected result: %s", (Object[])new Object[]{value});
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public String toString() {
        return "NamePart(name=" + this.getName() + ")";
    }

    @Generated
    private NamePart(String name) {
        this.name = name;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NamePart)) {
            return false;
        }
        NamePart other = (NamePart)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NamePart;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }
}

