/*
 * Decompiled with CFR 0.152.
 */
package it.kamaladafrica.codicefiscale.internal;

import it.kamaladafrica.codicefiscale.internal.AbstractPart;
import it.kamaladafrica.codicefiscale.utils.PartUtils;
import lombok.Generated;
import org.apache.commons.lang3.Validate;

public final class LastnamePart
extends AbstractPart {
    public static final int PART_LENGTH = 3;
    private static final String MISSING_LETTERS_PLACEHOLDER = "XXX";
    private static final String VALIDATION_PATTERN = "^(?:[A-Z][AEIOU][AEIOUX]|[B-DF-HJ-NP-TV-Z]{2}[A-Z])$";
    private final String name;

    public static LastnamePart from(String value) {
        Validate.notEmpty((CharSequence)value, (String)"invalid name: %s", (Object[])new Object[]{value});
        Validate.matchesPattern((CharSequence)value, (String)VALIDATION_PATTERN, (String)"invalid value: %s", (Object[])new Object[]{value});
        value = PartUtils.removePlaceholderIfPresent(value);
        return LastnamePart.of(value);
    }

    public static LastnamePart of(String value) {
        Validate.notEmpty((CharSequence)value, (String)"invalid name: %s", (Object[])new Object[]{value});
        Validate.validIndex((CharSequence)PartUtils.normalizeString(value), (int)1, (String)"invalid name: %s", (Object[])new Object[]{value});
        return new LastnamePart(value);
    }

    @Override
    protected String computeValue() {
        String name = PartUtils.normalizeString(this.getName());
        StringBuilder part = new StringBuilder();
        part.append(PartUtils.extractConsonants(name));
        part.append(PartUtils.extractVowels(name));
        part.append(MISSING_LETTERS_PLACEHOLDER);
        part.setLength(3);
        Validate.matchesPattern((CharSequence)part, (String)VALIDATION_PATTERN, (String)"unexpected result: %s", (Object[])new Object[]{part});
        return part.toString();
    }

    @Override
    protected String applyOmocodeLevel(String computeValue) {
        return computeValue;
    }

    @Override
    protected void validateValue(String value) {
        Validate.matchesPattern((CharSequence)value, (String)VALIDATION_PATTERN, (String)"unexpected result: %s", (Object[])new Object[]{value});
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public String toString() {
        return "LastnamePart(name=" + this.getName() + ")";
    }

    @Generated
    private LastnamePart(String name) {
        this.name = name;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LastnamePart)) {
            return false;
        }
        LastnamePart other = (LastnamePart)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LastnamePart;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }
}

