/*
 * Decompiled with CFR 0.152.
 */
package it.kamaladafrica.codicefiscale.internal;

import it.kamaladafrica.codicefiscale.CodiceFiscale;
import it.kamaladafrica.codicefiscale.internal.AbstractPart;
import lombok.Generated;
import org.apache.commons.lang3.Validate;

public final class ControlPart
extends AbstractPart {
    private static final String VALIDATION_INPUT_PATTERN = "^(?:[A-Z][AEIOU][AEIOUX]|[B-DF-HJ-NP-TV-Z]{2}[A-Z]){2}(?:[\\dLMNP-V]{2}(?:[A-EHLMPR-T](?:[04LQ][1-9MNP-V]|[15MR][\\dLMNP-V]|[26NS][0-8LMNP-U])|[DHPS][37PT][0L]|[ACELMRT][37PT][01LM]|[AC-EHLMPR-T][26NS][9V])|(?:[02468LNQSU][048LQU]|[13579MPRTV][26NS])B[26NS][9V])(?:[A-MZ][1-9MNP-V][\\dLMNP-V]{2}|[A-M][0L](?:[1-9MNP-V][\\dLMNP-V]|[0L][1-9MNP-V]))$";
    private static final String VALIDATION_RESULT_PATTERN = "^[A-Z]$";
    private static final int[] EVEN_WEIGHTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25};
    private static final int[] ODD_WEIGHTS = new int[]{1, 0, 5, 7, 9, 13, 15, 17, 19, 21, 2, 4, 18, 20, 11, 3, 6, 8, 12, 14, 16, 10, 22, 25, 24, 23};
    private static final char CHAR_ZERO = '0';
    private static final char CHAR_A = 'A';
    private final String code;

    public static ControlPart of(String value) {
        Validate.matchesPattern((CharSequence)value, (String)VALIDATION_INPUT_PATTERN, (String)"invalid value: %s", (Object[])new Object[]{value});
        return new ControlPart(value);
    }

    @Override
    protected String computeValue() {
        int even = 0;
        int odd = 0;
        char[] chars = this.code.toUpperCase(CodiceFiscale.LOCALE).toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            int index = this.charToIndex(c);
            if (this.isEven(i + 1)) {
                even += EVEN_WEIGHTS[index];
                continue;
            }
            odd += ODD_WEIGHTS[index];
        }
        int controlCharIndex = (even + odd) % 26;
        String value = String.valueOf((char)(65 + controlCharIndex));
        Validate.matchesPattern((CharSequence)value, (String)VALIDATION_RESULT_PATTERN, (String)"unexpected result: %s", (Object[])new Object[]{value});
        return value;
    }

    private boolean isEven(int i) {
        return (i & 1) == 0;
    }

    private int charToIndex(char c) {
        int baseValue = Character.isDigit(c) ? 48 : 65;
        return c - baseValue;
    }

    @Override
    protected String applyOmocodeLevel(String computeValue) {
        return computeValue;
    }

    public boolean isEqual(char controlChar) {
        return this.getValue().charAt(0) == controlChar;
    }

    public boolean isEqual(String controlChar) {
        Validate.matchesPattern((CharSequence)controlChar, (String)VALIDATION_RESULT_PATTERN, (String)"unexpected input: %s", (Object[])new Object[]{controlChar});
        return this.getValue().equals(controlChar);
    }

    @Override
    protected void validateValue(String value) {
        Validate.matchesPattern((CharSequence)value, (String)VALIDATION_RESULT_PATTERN, (String)"unexpected result: %s", (Object[])new Object[]{value});
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Override
    @Generated
    public String toString() {
        return "ControlPart(code=" + this.getCode() + ")";
    }

    @Generated
    private ControlPart(String code) {
        this.code = code;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ControlPart)) {
            return false;
        }
        ControlPart other = (ControlPart)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        return !(this$code == null ? other$code != null : !this$code.equals(other$code));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ControlPart;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        return result;
    }
}

