/*
 * Decompiled with CFR 0.152.
 */
package it.kamaladafrica.codicefiscale.internal;

import com.google.common.primitives.ImmutableIntArray;
import it.kamaladafrica.codicefiscale.City;
import it.kamaladafrica.codicefiscale.city.CityByBelfiore;
import it.kamaladafrica.codicefiscale.city.CityProvider;
import it.kamaladafrica.codicefiscale.internal.AbstractPart;
import it.kamaladafrica.codicefiscale.utils.OmocodeUtils;
import lombok.Generated;
import org.apache.commons.lang3.Validate;

public final class BelfiorePart
extends AbstractPart {
    private static final String VALIDATION_PATTERN = "^(?:[A-MZ][1-9MNP-V][\\dLMNP-V]{2}|[A-M][0L](?:[1-9MNP-V][\\dLMNP-V]|[0L][1-9MNP-V]))$";
    private static final ImmutableIntArray OMOCODE_INDEXES = ImmutableIntArray.of((int)3, (int)2, (int)1);
    private final City city;

    private BelfiorePart(City city, int level) {
        super(level);
        Validate.inclusiveBetween((Object)0, (Object)OMOCODE_INDEXES.length(), (Comparable)Integer.valueOf(level), (String)"invalid omocode level for Belfiore part: 0 <= %s <= %s", (Object[])new Object[]{level, OMOCODE_INDEXES.length()});
        this.city = city;
    }

    public static BelfiorePart from(String value) {
        return BelfiorePart.from(value, CityProvider.ofDefault());
    }

    public static BelfiorePart from(String value, CityByBelfiore provider) {
        Validate.notEmpty((CharSequence)value, (String)"invalid value: %s", (Object[])new Object[]{value});
        Validate.notNull((Object)provider);
        Validate.matchesPattern((CharSequence)value, (String)VALIDATION_PATTERN, (String)"invalid value: %s", (Object[])new Object[]{value});
        City input = BelfiorePart.toInput(value, provider);
        Validate.notNull((Object)input, (String)"belfiore not found", (Object[])new Object[0]);
        return new BelfiorePart(input, BelfiorePart.getOmocodeLevel(value));
    }

    private static int getOmocodeLevel(String value) {
        return OmocodeUtils.level(value, OMOCODE_INDEXES.toArray());
    }

    public static BelfiorePart of(City city) {
        return new BelfiorePart(city);
    }

    @Override
    protected String computeValue() {
        String value = this.city.getBelfiore();
        Validate.matchesPattern((CharSequence)value, (String)VALIDATION_PATTERN, (String)"invalid value: %s", (Object[])new Object[]{value});
        return value;
    }

    private static City toInput(String value, CityByBelfiore provider) {
        value = BelfiorePart.normalizeOmocode(value);
        return provider.findByBelfiore(value);
    }

    private static String normalizeOmocode(String value) {
        return OmocodeUtils.normalize(value, OMOCODE_INDEXES.toArray());
    }

    @Override
    protected String applyOmocodeLevel(String value) {
        int level = this.getOmocodeLevel();
        if (level > 0) {
            return OmocodeUtils.apply(value, OMOCODE_INDEXES.subArray(0, level).toArray());
        }
        return value;
    }

    public BelfiorePart toOmocodeLevel(int level) {
        return this.getOmocodeLevel() == level ? this : new BelfiorePart(this.city, level);
    }

    @Override
    protected void validateValue(String value) {
        Validate.matchesPattern((CharSequence)value, (String)VALIDATION_PATTERN, (String)"unexpected result: %s", (Object[])new Object[]{value});
    }

    @Generated
    public City getCity() {
        return this.city;
    }

    @Generated
    private BelfiorePart(City city) {
        this.city = city;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BelfiorePart)) {
            return false;
        }
        BelfiorePart other = (BelfiorePart)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        City this$city = this.getCity();
        City other$city = other.getCity();
        return !(this$city == null ? other$city != null : !((Object)this$city).equals(other$city));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BelfiorePart;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        City $city = this.getCity();
        result = result * 59 + ($city == null ? 43 : ((Object)$city).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "BelfiorePart(super=" + super.toString() + ", city=" + this.getCity() + ")";
    }
}

