/*
 * Decompiled with CFR 0.152.
 */
package it.kamaladafrica.codicefiscale.city.impl;

import it.kamaladafrica.codicefiscale.City;
import it.kamaladafrica.codicefiscale.CodiceFiscale;
import it.kamaladafrica.codicefiscale.city.impl.CsvSupplier;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;

public final class ItaliaCsvSupplier
extends CsvSupplier {
    private ItaliaCsvSupplier(URL resource) {
        super(resource, StandardCharsets.UTF_8, ItaliaCsvSupplier.buildFormat(), ItaliaCsvSupplier.mapper());
    }

    private static Function<CSVRecord, City> mapper() {
        return record -> City.builder().name(record.get(1).toUpperCase(CodiceFiscale.LOCALE)).prov(record.get(2).toUpperCase(CodiceFiscale.LOCALE)).belfiore(record.get(0).toUpperCase(CodiceFiscale.LOCALE)).build();
    }

    private static CSVFormat buildFormat() {
        return CSVFormat.DEFAULT.withDelimiter(',').withFirstRecordAsHeader().withTrim();
    }

    public static ItaliaCsvSupplier of(URL url) {
        return new ItaliaCsvSupplier(url);
    }
}

